/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.ReifierFragmentHandler;
import com.hp.hpl.jena.graph.impl.ReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.ReifierTripleMap;
import com.hp.hpl.jena.graph.impl.SimpleReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.SimpleReifierTripleMap;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.vocabulary.RDF;

public class SimpleReifier
implements Reifier {
    protected final GraphBase parent;
    protected final boolean intercepting;
    protected final boolean concealing;
    protected final ReificationStyle style;
    protected ReifierFragmentsMap fragmentsMap;
    protected ReifierTripleMap tripleMap;
    protected boolean closed = false;

    public SimpleReifier(GraphBase graphBase, ReificationStyle reificationStyle) {
        this(graphBase, new SimpleReifierTripleMap(), new SimpleReifierFragmentsMap(), reificationStyle);
    }

    public SimpleReifier(GraphBase graphBase, ReifierTripleMap reifierTripleMap, ReifierFragmentsMap reifierFragmentsMap, ReificationStyle reificationStyle) {
        this.parent = graphBase;
        this.fragmentsMap = reifierFragmentsMap;
        this.tripleMap = reifierTripleMap;
        this.intercepting = reificationStyle.intercepts();
        this.concealing = reificationStyle.conceals();
        this.style = reificationStyle;
    }

    public ReificationStyle getStyle() {
        return this.style;
    }

    public Graph getParentGraph() {
        return this.parent;
    }

    public Triple getTriple(Node node) {
        return this.tripleMap.getTriple(node);
    }

    public boolean hasTriple(Node node) {
        return this.getTriple(node) != null;
    }

    public ExtendedIterator allNodes() {
        return this.tripleMap.tagIterator();
    }

    public ExtendedIterator allNodes(Triple triple) {
        return this.tripleMap.tagIterator(triple);
    }

    public Node reifyAs(Node node, Triple triple) {
        Triple triple2 = this.tripleMap.getTriple(node);
        if (triple2 != null) {
            if (!triple.equals(triple2)) {
                throw new AlreadyReifiedException(node);
            }
        } else {
            this.reifyNewTriple(node, triple);
        }
        if (!this.concealing) {
            SimpleReifier.graphAddQuad(this.parent, node, triple);
        }
        return node;
    }

    protected void reifyNewTriple(Node node, Triple triple) {
        if (this.fragmentsMap.hasFragments(node)) {
            SimpleReifier.graphAddQuad(this.parent, node, triple);
            if (this.tripleMap.getTriple(node) == null) {
                throw new CannotReifyException(node);
            }
        } else {
            this.tripleMap.putTriple(node, triple);
        }
    }

    public void remove(Node node, Triple triple) {
        Triple triple2 = this.tripleMap.getTriple(node);
        if (triple.equals(triple2)) {
            this.tripleMap.removeTriple(node, triple);
            if (!this.concealing) {
                this.parentRemoveQuad(node, triple);
            }
        }
    }

    public void remove(Triple triple) {
        this.tripleMap.removeTriple(triple);
    }

    public boolean hasTriple(Triple triple) {
        return this.tripleMap.hasTriple(triple);
    }

    public boolean handledAdd(Triple triple) {
        if (this.intercepting) {
            ReifierFragmentHandler reifierFragmentHandler = this.fragmentsMap.getFragmentHandler(triple);
            if (reifierFragmentHandler == null) {
                return false;
            }
            this.addFragment(reifierFragmentHandler, triple);
            return true;
        }
        return false;
    }

    protected void addFragment(ReifierFragmentHandler reifierFragmentHandler, Triple triple) {
        Node node = triple.getSubject();
        Node node2 = triple.getObject();
        Triple triple2 = this.tripleMap.getTriple(node);
        if (triple2 == null) {
            this.updateFragments(reifierFragmentHandler, triple, node, node2);
        } else if (reifierFragmentHandler.clashedWith(node2, triple2)) {
            this.tripleMap.removeTriple(node, triple2);
        }
    }

    private void updateFragments(ReifierFragmentHandler reifierFragmentHandler, Triple triple, Node node, Node node2) {
        Triple triple2 = reifierFragmentHandler.reifyIfCompleteQuad(triple, node, node2);
        if (triple2 instanceof Triple) {
            this.tripleMap.putTriple(node, triple2);
        }
    }

    public boolean handledRemove(Triple triple) {
        if (this.intercepting) {
            ReifierFragmentHandler reifierFragmentHandler = this.fragmentsMap.getFragmentHandler(triple);
            if (reifierFragmentHandler == null) {
                return false;
            }
            this.removeFragment(reifierFragmentHandler, triple);
            return true;
        }
        return false;
    }

    private void removeFragment(ReifierFragmentHandler reifierFragmentHandler, Triple triple) {
        Triple triple2;
        Node node = triple.getSubject();
        Triple triple3 = reifierFragmentHandler.removeFragment(node, triple2 = this.tripleMap.getTriple(node), triple);
        if (triple3 == null) {
            this.tripleMap.removeTriple(node);
        } else {
            this.tripleMap.putTriple(node, triple3);
        }
    }

    public ExtendedIterator find(TripleMatch tripleMatch) {
        return this.tripleMap.find(tripleMatch).andThen(this.fragmentsMap.find(tripleMatch));
    }

    public ExtendedIterator findExposed(TripleMatch tripleMatch) {
        return this.findEither(tripleMatch, false);
    }

    public ExtendedIterator findEither(TripleMatch tripleMatch, boolean bl) {
        return bl == this.concealing ? this.find(tripleMatch) : NullIterator.instance;
    }

    public int size() {
        return this.concealing ? 0 : this.tripleMap.size() + this.fragmentsMap.size();
    }

    private void parentRemoveQuad(Node node, Triple triple) {
        this.parent.delete(Triple.create(node, RDF.Nodes.type, RDF.Nodes.Statement));
        this.parent.delete(Triple.create(node, RDF.Nodes.subject, triple.getSubject()));
        this.parent.delete(Triple.create(node, RDF.Nodes.predicate, triple.getPredicate()));
        this.parent.delete(Triple.create(node, RDF.Nodes.object, triple.getObject()));
    }

    public static void graphAddQuad(GraphAdd graphAdd, Node node, Triple triple) {
        graphAdd.add(Triple.create(node, RDF.Nodes.subject, triple.getSubject()));
        graphAdd.add(Triple.create(node, RDF.Nodes.predicate, triple.getPredicate()));
        graphAdd.add(Triple.create(node, RDF.Nodes.object, triple.getObject()));
        graphAdd.add(Triple.create(node, RDF.Nodes.type, RDF.Nodes.Statement));
    }

    public String toString() {
        return "<R " + this.fragmentsMap + "|" + this.tripleMap + ">";
    }

    public void close() {
        this.fragmentsMap = null;
        this.tripleMap = null;
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

