/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Bag;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.ResultBindingImpl;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QueryTestProgrammatic
extends TestSuite {
    static final String testSetName = "RDQL - Query - Programmatic";
    public static boolean dumpModel = false;
    public static boolean verbose = false;

    public static TestSuite suite() {
        return new QueryTestProgrammatic(testSetName);
    }

    private QueryTestProgrammatic(String string) {
        super(string);
        try {
            Model model = QueryTestProgrammatic.makeModel1();
            Model model2 = QueryTestProgrammatic.makeModel2();
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-1", model, "SELECT ?x, ?z WHERE (?x, ?a, ?b), (?b, ?y, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-2", model, "SELECT ?z WHERE (?x, ?y, ?z) AND ?z == 1"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-3", model, "SELECT ?z WHERE (<http://never/r-1>, <http://never/p-0>, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-4", model2, "SELECT ?x, ?a, ?b, ?y, ?z WHERE (?x, ?a, ?b), (?b, ?y, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-5", model2, "SELECT ?z WHERE (?x, ?y, ?z) AND ?z == 1"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-6", model2, "SELECT ?z WHERE (<http://never/r-1>, <http://never/p-0>, ?z)"));
            ResultBindingImpl resultBindingImpl = new ResultBindingImpl();
            resultBindingImpl.add("x", model.createResource("http://never/r-1"));
            resultBindingImpl.add("y", model.createResource("http://never/p-1"));
            this.addTest((Test)new TestQueryTemplate("RDQL-Test-Template-1", model, null, "SELECT * WHERE (?x, ?y, ?z)", model.size()));
            this.addTest((Test)new TestQueryTemplate("RDQL-Test-Template-2", model, resultBindingImpl, "SELECT * WHERE (?x, ?y, ?z)", 1L));
        }
        catch (Exception exception) {
            System.err.println("Problems making RDQL test");
            exception.printStackTrace(System.err);
            return;
        }
    }

    public static Model makeModel1() throws Exception {
        Model model = ModelFactory.createDefaultModel();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                model.add(model.createResource("http://never/r-" + i), model.createProperty("http://never/p-" + j), i + j);
            }
        }
        Bag bag = model.createBag("http://never/bag");
        bag.add("11");
        bag.add("22");
        model.add(model.createResource("http://never/path"), model.createProperty("http://never/path"), model.createResource("http://never/r-0"));
        return model;
    }

    public static Model makeModel2() throws Exception {
        Model model = QueryTestProgrammatic.makeModel1();
        Resource resource = model.createResource();
        Resource resource2 = model.createResource();
        model.add(resource, model.createProperty("http://never/p-anon-1"), "p-anon-1");
        model.add(resource2, model.createProperty("http://never/p-anon-2"), "p-anon-2");
        model.add(resource, model.createProperty("http://never/p-anon-1-2"), resource2);
        return model;
    }

    static class TestQueryTemplate
    extends TestCase {
        Model model;
        String queryString;
        ResultBindingImpl binding;
        long numResults;

        TestQueryTemplate(String string, Model model, ResultBindingImpl resultBindingImpl, String string2, long l) {
            super(string);
            this.model = model;
            this.queryString = string2;
            this.binding = resultBindingImpl;
            this.numResults = l;
        }

        protected void runTest() throws Throwable {
            if (verbose) {
                System.out.println();
                System.out.println("Query:");
                System.out.println(this.queryString);
            }
            Query query = new Query(this.queryString);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec(this.binding);
            QueryEngine queryEngine2 = queryEngine;
            long l = 0L;
            while (queryResults.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)queryResults.next();
                if (resultBinding == null) {
                    throw new Exception("TestQueryTemplate: found null result binding");
                }
                Iterator iterator = query.getResultVars().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    String string = (String)iterator.next();
                    Object object2 = resultBinding.get(string);
                    TestQueryTemplate.assertNotNull((String)("Variable: " + string), (Object)object2);
                    if (this.binding == null || (object = this.binding.get(string)) == null) continue;
                    TestQueryTemplate.assertTrue((String)("Variable: " + string + " = " + object + " / " + object2), (boolean)object.equals(object2));
                }
                ++l;
            }
            queryResults.close();
            if (l != this.numResults) {
                throw new Exception("TestQueryTemplate: mismatch in counts.  Expected " + this.numResults + ".  Got " + l + "  Query: " + this.queryString);
            }
        }
    }

    static class TestProgrammatic
    extends TestCase {
        Model model;
        String queryString;

        TestProgrammatic(String string, Model model, String string2) {
            super(string);
            this.model = model;
            this.queryString = string2;
        }

        protected void runTest() throws Throwable {
            if (verbose) {
                System.out.println();
                System.out.println("Query:");
                System.out.println(this.queryString);
            }
            Query query = new Query(this.queryString);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            while (queryResults.hasNext()) {
                ResultBindingImpl resultBindingImpl = (ResultBindingImpl)queryResults.next();
                Iterator iterator = resultBindingImpl.getTriples().iterator();
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    TestProgrammatic.assertTrue((String)"Statement not in model", (boolean)this.model.contains(statement));
                }
            }
            queryResults.close();
        }
    }
}

