/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryEquivalentsTranslator
extends DIGQueryTranslator {
    protected boolean m_subjectFree;

    public DIGQueryEquivalentsTranslator(String string, boolean bl) {
        super(null, string, null);
        this.m_subjectFree = bl;
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        Element element = dIGAdapter.createQueryElement(document, "equivalents");
        dIGAdapter.addClassDescription(element, this.m_subjectFree ? triplePattern.getObject() : triplePattern.getSubject());
        return document;
    }

    public ExtendedIterator translateResponseHook(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        return this.translateConceptSetResponse(document, triplePattern, !this.m_subjectFree, dIGAdapter);
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return null;
    }

    public boolean checkSubject(Node node, DIGAdapter dIGAdapter, Model model) {
        return this.m_subjectFree && !node.isConcrete() || dIGAdapter.isConcept(node, model);
    }

    public boolean checkObject(Node node, DIGAdapter dIGAdapter, Model model) {
        return !this.m_subjectFree && !node.isConcrete() || dIGAdapter.isConcept(node, model);
    }

    public boolean checkTriple(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return super.checkTriple(triplePattern, dIGAdapter, model) && (!triplePattern.getSubject().isConcrete() || !triplePattern.getObject().isConcrete());
    }
}

