/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.model.helper;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataEnumeration;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDeprecatableObject;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLRestriction;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.change.AddAnnotationInstance;
import org.semanticweb.owl.model.change.AddClassAxiom;
import org.semanticweb.owl.model.change.AddDataPropertyInstance;
import org.semanticweb.owl.model.change.AddDataPropertyRange;
import org.semanticweb.owl.model.change.AddDataType;
import org.semanticweb.owl.model.change.AddDomain;
import org.semanticweb.owl.model.change.AddEntity;
import org.semanticweb.owl.model.change.AddEnumeration;
import org.semanticweb.owl.model.change.AddEquivalentClass;
import org.semanticweb.owl.model.change.AddIndividualAxiom;
import org.semanticweb.owl.model.change.AddIndividualClass;
import org.semanticweb.owl.model.change.AddInverse;
import org.semanticweb.owl.model.change.AddObjectPropertyInstance;
import org.semanticweb.owl.model.change.AddObjectPropertyRange;
import org.semanticweb.owl.model.change.AddPropertyAxiom;
import org.semanticweb.owl.model.change.AddSuperClass;
import org.semanticweb.owl.model.change.AddSuperProperty;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.model.change.OntologyChange;
import org.semanticweb.owl.model.change.SetDeprecated;
import org.semanticweb.owl.model.change.SetFunctional;
import org.semanticweb.owl.model.change.SetInverseFunctional;
import org.semanticweb.owl.model.change.SetSymmetric;
import org.semanticweb.owl.model.change.SetTransitive;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;

public class OWLBuilder {
    public static final int SYMMETRIC = 11;
    public static final int FUNCTIONAL = 12;
    public static final int INVERSE_FUNCTIONAL = 13;
    public static final int TRANSITIVE = 14;
    static Logger logger = Logger.getLogger((class$org$semanticweb$owl$model$helper$OWLBuilder == null ? (class$org$semanticweb$owl$model$helper$OWLBuilder = OWLBuilder.class$("org.semanticweb.owl.model.helper.OWLBuilder")) : class$org$semanticweb$owl$model$helper$OWLBuilder).getName());
    OWLOntology owlOntology;
    ChangeVisitor changeVisitor;
    OWLDataFactory owlDataFactory;
    OWLConnection connection;
    static /* synthetic */ Class class$org$semanticweb$owl$model$helper$OWLBuilder;

    public OWLOntology getOntology() {
        return this.owlOntology;
    }

    public ChangeVisitor getChangeVisitor() {
        return this.changeVisitor;
    }

    public OWLDataFactory getDataFactory() {
        return this.owlDataFactory;
    }

    public OWLConnection getConnection() {
        return this.connection;
    }

    public void setConnection(OWLConnection newConnection) {
        this.connection = newConnection;
    }

    public OWLBuilder() {
        try {
            this.connection = OWLManager.getOWLConnection();
        }
        catch (OWLException e) {
            System.err.println("Could not obtain connection");
            System.exit(-1);
        }
    }

    public OWLBuilder(OWLConnection connection) {
        this.connection = connection;
    }

    public void createOntology(URI id, URI physicalURI) throws OWLException {
        logger.fine("connection " + this.connection);
        this.owlDataFactory = this.connection.getDataFactory();
        if (id == null) {
            id = URI.create("urn:defaultOntologyUri");
        }
        this.owlOntology = this.owlDataFactory.getOWLOntology(id, physicalURI);
        this.changeVisitor = this.connection.getChangeVisitor(this.owlOntology);
    }

    public OWLClass getClass(URI id) throws OWLException {
        return this.owlDataFactory.getOWLClass(id);
    }

    public OWLClass addClass(URI id) throws OWLException {
        OWLClass oClass = this.getClass(id);
        new AddEntity(this.owlOntology, oClass, null).accept(this.changeVisitor);
        return oClass;
    }

    public OWLIndividual getIndividual(URI id) throws OWLException {
        return this.owlDataFactory.getOWLIndividual(id);
    }

    public OWLIndividual addIndividual(URI id) throws OWLException {
        OWLIndividual individual = this.getIndividual(id);
        AddEntity ae = new AddEntity(this.owlOntology, individual, null);
        ae.accept(this.changeVisitor);
        return individual;
    }

    public void addAnnotationInstance(OWLObject subject, AnnotationComponent annComponent) throws OWLException {
        new AddAnnotationInstance(this.owlOntology, subject, annComponent.getProperty(), annComponent.getContent(), null).accept(this.changeVisitor);
    }

    public void addOntologyAnnotationInstance(AnnotationComponent annComponent) throws OWLException {
        this.addAnnotationInstance(this.owlOntology, annComponent);
    }

    public OWLObjectProperty getObjectProperty(URI id) throws OWLException {
        return this.owlDataFactory.getOWLObjectProperty(id);
    }

    public OWLAnnotationProperty getAnnotationProperty(URI id) throws OWLException {
        return this.owlDataFactory.getOWLAnnotationProperty(id);
    }

    public OWLObjectProperty addObjectProperty(URI id) throws OWLException {
        OWLObjectProperty entity = this.getObjectProperty(id);
        new AddEntity(this.owlOntology, entity, null).accept(this.changeVisitor);
        return entity;
    }

    public OWLObjectProperty addInverse(OWLObjectProperty property, URI inverseId) throws OWLException {
        OWLObjectProperty inverse = this.addObjectProperty(inverseId);
        new AddInverse(this.owlOntology, property, inverse, null).accept(this.changeVisitor);
        return inverse;
    }

    public OWLDataProperty getDataProperty(URI id) throws OWLException {
        return this.owlDataFactory.getOWLDataProperty(id);
    }

    public OWLDataProperty addDataProperty(URI id) throws OWLException {
        OWLDataProperty prop = this.getDataProperty(id);
        new AddEntity(this.owlOntology, prop, null).accept(this.changeVisitor);
        return prop;
    }

    public void setDeprecatedObject(OWLDeprecatableObject deprecatable) throws OWLException {
        new SetDeprecated(this.owlOntology, deprecatable, true, null).accept(this.changeVisitor);
    }

    public void addDescriptionToIndividual(OWLDescription description, OWLIndividual individual) throws OWLException {
        new AddIndividualClass(this.owlOntology, individual, description, null).accept(this.changeVisitor);
    }

    public void addSameIndividualsAxiom(Set individuals) throws OWLException {
        OWLSameIndividualsAxiom axiom = this.owlDataFactory.getOWLSameIndividualsAxiom(this.toOWLIndividuals(individuals));
        new AddIndividualAxiom(this.owlOntology, axiom, null).accept(this.changeVisitor);
    }

    public void addDifferentIndividualsAxiom(Set individuals) throws OWLException {
        OWLDifferentIndividualsAxiom axiom = this.owlDataFactory.getOWLDifferentIndividualsAxiom(this.toOWLIndividuals(individuals));
        new AddIndividualAxiom(this.owlOntology, axiom, null).accept(this.changeVisitor);
    }

    public void setPropertyType(OWLObjectProperty property, int type) throws OWLException {
        OntologyChange change = null;
        switch (type) {
            case 11: {
                change = new SetSymmetric(this.owlOntology, property, true, null);
                break;
            }
            case 12: {
                change = new SetFunctional(this.owlOntology, property, true, null);
                break;
            }
            case 13: {
                change = new SetInverseFunctional(this.owlOntology, property, true, null);
                break;
            }
            case 14: {
                change = new SetTransitive(this.owlOntology, property, true, null);
                break;
            }
            default: {
                throw new RuntimeException("Property type " + type + " not supported");
            }
        }
        change.accept(this.changeVisitor);
    }

    public void setDataPropertyFunctional(OWLDataProperty property) throws OWLException {
        new SetFunctional(this.owlOntology, property, true, null).accept(this.changeVisitor);
    }

    public void addEnumeration(OWLClass oClass, Set individuals) throws OWLException {
        OWLEnumeration oEnum = this.owlDataFactory.getOWLEnumeration(this.toOWLIndividuals(individuals));
        new AddEnumeration(this.owlOntology, oClass, oEnum, null).accept(this.changeVisitor);
    }

    public void addEquivalentClass(OWLClass oClass, Set descriptions) throws OWLException {
        int descriptionsCount = descriptions.size();
        if (descriptionsCount > 0) {
            AddEquivalentClass equiv;
            if (descriptionsCount == 1) {
                equiv = new AddEquivalentClass(this.owlOntology, oClass, (OWLDescription)descriptions.iterator().next(), null);
            } else {
                OWLAnd conjunction = this.owlDataFactory.getOWLAnd(descriptions);
                equiv = new AddEquivalentClass(this.owlOntology, oClass, conjunction, null);
            }
            equiv.accept(this.changeVisitor);
        }
    }

    public void addSuperClass(OWLClass oClass, Set descriptions) throws OWLException {
        int descriptionsCount = descriptions.size();
        if (descriptionsCount > 0) {
            AddSuperClass sups;
            if (descriptionsCount == 1) {
                sups = new AddSuperClass(this.owlOntology, oClass, (OWLDescription)descriptions.iterator().next(), null);
            } else {
                OWLAnd conjunction = this.owlDataFactory.getOWLAnd(descriptions);
                sups = new AddSuperClass(this.owlOntology, oClass, conjunction, null);
            }
            sups.accept(this.changeVisitor);
        }
    }

    public void addDisjointClassesAxiom(Set disjuncts) throws OWLException {
        this.addClassAxiom(this.owlDataFactory.getOWLDisjointClassesAxiom(disjuncts));
    }

    public void addEquivalentClassesAxiom(Set equivalents) throws OWLException {
        this.addClassAxiom(this.owlDataFactory.getOWLEquivalentClassesAxiom(equivalents));
    }

    public void addSubClassAxiom(OWLDescription description1, OWLDescription description2) throws OWLException {
        this.addClassAxiom(this.owlDataFactory.getOWLSubClassAxiom(description1, description2));
    }

    public void addClassAxiom(OWLClassAxiom axiom) throws OWLException {
        AddClassAxiom ae = new AddClassAxiom(this.owlOntology, axiom, null);
        ae.accept(this.changeVisitor);
    }

    public OWLDataType addDataType(URI id) throws OWLException {
        OWLDataType datatype = this.owlDataFactory.getOWLConcreteDataType(id);
        new AddDataType(this.owlOntology, datatype, null).accept(this.changeVisitor);
        return datatype;
    }

    public void addDataSubPropertyAxiom(URI subId, URI supId) throws OWLException {
        OWLDataProperty subProp = this.getDataProperty(subId);
        OWLDataProperty supProp = this.getDataProperty(supId);
        this.addPropertyAxiom(this.owlDataFactory.getOWLSubPropertyAxiom(subProp, supProp));
    }

    public void addSuperProperty(OWLProperty property, OWLProperty superProperty) throws OWLException {
        new AddSuperProperty(this.owlOntology, property, superProperty, null).accept(this.changeVisitor);
    }

    public void addObjectSubPropertyAxiom(URI subId, URI supId) throws OWLException {
        OWLObjectProperty subProp = this.getObjectProperty(subId);
        OWLObjectProperty supProp = this.getObjectProperty(supId);
        this.addPropertyAxiom(this.owlDataFactory.getOWLSubPropertyAxiom(subProp, supProp));
    }

    public void addPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
        new AddPropertyAxiom(this.owlOntology, axiom, null).accept(this.changeVisitor);
    }

    public void addPropertyDomain(OWLProperty property, OWLDescription domain) throws OWLException {
        new AddDomain(this.owlOntology, property, domain, null).accept(this.changeVisitor);
    }

    public void addObjectPropertyRange(OWLObjectProperty property, OWLDescription range) throws OWLException {
        new AddObjectPropertyRange(this.owlOntology, property, range, null).accept(this.changeVisitor);
    }

    public void addDataPropertyRange(OWLDataProperty property, OWLDataRange range) throws OWLException {
        new AddDataPropertyRange(this.owlOntology, property, range, null).accept(this.changeVisitor);
    }

    public void addEquivalentObjectPropertiesAxiom(Set equivalents) throws OWLException {
        new AddPropertyAxiom(this.owlOntology, this.owlDataFactory.getOWLEquivalentPropertiesAxiom(this.toOWLObjectProperties(equivalents)), null).accept(this.changeVisitor);
    }

    public void addEquivalentDataPropertiesAxiom(Set equivalents) throws OWLException {
        new AddPropertyAxiom(this.owlOntology, this.owlDataFactory.getOWLEquivalentPropertiesAxiom(this.toOWLDataProperties(equivalents)), null).accept(this.changeVisitor);
    }

    public OWLDescription unionOf(Set descriptions) throws OWLException {
        return this.owlDataFactory.getOWLOr(descriptions);
    }

    public OWLDescription intersectionOf(Set descriptions) throws OWLException {
        return this.owlDataFactory.getOWLAnd(descriptions);
    }

    public OWLDescription complementOf(OWLDescription description) throws OWLException {
        return this.owlDataFactory.getOWLNot(description);
    }

    public OWLEnumeration oneOf(Set individuals) throws OWLException {
        return this.owlDataFactory.getOWLEnumeration(this.toOWLIndividuals(individuals));
    }

    public Set toOWLIndividuals(Set individualURIs) throws OWLException {
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        Iterator i = individualURIs.iterator();
        while (i.hasNext()) {
            individuals.add(this.getIndividual((URI)i.next()));
        }
        return individuals;
    }

    public Set toOWLObjectProperties(Set objectPropertyURIs) throws OWLException {
        HashSet<OWLObjectProperty> objectProperties = new HashSet<OWLObjectProperty>();
        Iterator i = objectPropertyURIs.iterator();
        while (i.hasNext()) {
            objectProperties.add(this.getObjectProperty((URI)i.next()));
        }
        return objectProperties;
    }

    public static Set toURIs(Set uriStrings) throws URISyntaxException {
        HashSet<URI> uris = new HashSet<URI>();
        Iterator i = uriStrings.iterator();
        while (i.hasNext()) {
            String idString = (String)i.next();
            uris.add(new URI(idString));
        }
        return uris;
    }

    public Set toOWLDataProperties(Set dataPropertyURIs) throws OWLException {
        HashSet<OWLDataProperty> dataProperties = new HashSet<OWLDataProperty>();
        Iterator i = dataPropertyURIs.iterator();
        while (i.hasNext()) {
            dataProperties.add(this.getDataProperty((URI)i.next()));
        }
        return dataProperties;
    }

    public OWLAnnotationProperty addAnnotationProperty(URI id) throws OWLException {
        OWLAnnotationProperty annotationProperty = this.getAnnotationProperty(id);
        new AddEntity(this.owlOntology, annotationProperty, null).accept(this.changeVisitor);
        return annotationProperty;
    }

    public OWLRestriction getObjectValueRestriction(URI propertyId, OWLIndividual individual) throws OWLException {
        return this.owlDataFactory.getOWLObjectValueRestriction(this.getObjectProperty(propertyId), individual);
    }

    public CardinalityComponent createCardinalityComponent(int type) {
        return new CardinalityComponent(type);
    }

    public DescriptionComponent createDescriptionComponent(OWLDescription description, int type) {
        return new DescriptionComponent(description, type);
    }

    public OWLRestriction getRestriction(OWLObjectProperty property, RestrictionComponent component) throws OWLException {
        if (component instanceof CardinalityComponent) {
            return this.getRestriction(property, (CardinalityComponent)component);
        }
        if (component instanceof DescriptionComponent) {
            return this.getRestriction(property, (DescriptionComponent)component);
        }
        if (component instanceof IndividualValueComponent) {
            return this.owlDataFactory.getOWLObjectValueRestriction(property, this.addIndividual(((IndividualValueComponent)component).getValue()));
        }
        return null;
    }

    public OWLRestriction getRestriction(OWLObjectProperty property, CardinalityComponent cComponent) throws OWLException {
        switch (cComponent.getType()) {
            case 1: {
                return this.owlDataFactory.getOWLObjectCardinalityAtMostRestriction(property, cComponent.getCardinality());
            }
            case 2: {
                return this.owlDataFactory.getOWLObjectCardinalityAtLeastRestriction(property, cComponent.getCardinality());
            }
            case 3: {
                int cardinality = cComponent.getCardinality();
                return this.owlDataFactory.getOWLObjectCardinalityRestriction(property, cardinality, cardinality);
            }
        }
        throw new CardinalityNotSupportedError();
    }

    public OWLRestriction getRestriction(OWLObjectProperty property, DescriptionComponent dComponent) throws OWLException {
        switch (dComponent.getType()) {
            case 1: {
                return this.owlDataFactory.getOWLObjectAllRestriction(property, dComponent.getDescription());
            }
            case 2: {
                return this.owlDataFactory.getOWLObjectSomeRestriction(property, dComponent.getDescription());
            }
        }
        throw new DescriptionRestrictionNotSupportedError();
    }

    public OWLRestriction getRestriction(OWLDataProperty property, RestrictionComponent component) throws OWLException {
        if (component instanceof CardinalityComponent) {
            return this.getRestriction(property, (CardinalityComponent)component);
        }
        if (component instanceof DataLiteralValueComponent) {
            return this.getRestriction(property, (DataLiteralValueComponent)component);
        }
        if (component instanceof DataRangeComponent) {
            return this.getRestriction(property, (DataRangeComponent)component);
        }
        return null;
    }

    public OWLRestriction getRestriction(OWLDataProperty property, CardinalityComponent card) throws OWLException {
        switch (card.getType()) {
            case 1: {
                return this.owlDataFactory.getOWLDataCardinalityAtMostRestriction(property, card.getCardinality());
            }
            case 2: {
                return this.owlDataFactory.getOWLDataCardinalityAtLeastRestriction(property, card.getCardinality());
            }
            case 3: {
                int cardinality = card.getCardinality();
                return this.owlDataFactory.getOWLDataCardinalityRestriction(property, cardinality, cardinality);
            }
        }
        throw new CardinalityNotSupportedError();
    }

    public OWLRestriction getRestriction(OWLDataProperty property, DataRangeComponent dRComponent) throws OWLException {
        switch (dRComponent.getType()) {
            case 1: {
                return this.owlDataFactory.getOWLDataAllRestriction(property, dRComponent.getDataRange());
            }
            case 2: {
                return this.owlDataFactory.getOWLDataSomeRestriction(property, dRComponent.getDataRange());
            }
        }
        throw new DataRangeRestrictionNotSupportedError();
    }

    public OWLRestriction getRestriction(OWLDataProperty property, DataLiteralValueComponent component) throws OWLException {
        return this.owlDataFactory.getOWLDataValueRestriction(property, component.getDataLiteral());
    }

    public OWLDataValue getConcreteData(URI uri, String lang, Object value) throws OWLException {
        return this.owlDataFactory.getOWLConcreteData(uri, lang, value);
    }

    public OWLDataType getConcreteDataType(URI uri) throws OWLException {
        return this.owlDataFactory.getOWLConcreteDataType(uri);
    }

    public OWLDataEnumeration getDataEnumeration(Set literals) throws OWLException {
        return this.owlDataFactory.getOWLDataEnumeration(literals);
    }

    public void addPropertyValue(OWLIndividual subject, PropertyValue propValue) throws OWLException {
        PropertyValue value;
        if (propValue instanceof ObjectPropertyValue) {
            value = (ObjectPropertyValue)propValue;
            new AddObjectPropertyInstance(this.owlOntology, subject, ((ObjectPropertyValue)value).getProperty(), ((ObjectPropertyValue)value).getIndividual(), null).accept(this.changeVisitor);
        }
        if (propValue instanceof DataPropertyValue) {
            value = (DataPropertyValue)propValue;
            new AddDataPropertyInstance(this.owlOntology, subject, ((DataPropertyValue)value).getProperty(), ((DataPropertyValue)value).getDataValue(), null).accept(this.changeVisitor);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DataRangeRestrictionNotSupportedError
    extends Error {
        DataRangeRestrictionNotSupportedError() {
        }
    }

    class DescriptionRestrictionNotSupportedError
    extends Error {
        DescriptionRestrictionNotSupportedError() {
        }
    }

    class CardinalityNotSupportedError
    extends Error {
        CardinalityNotSupportedError() {
        }
    }

    public static interface RestrictionComponent {
    }

    public static class AnnotationComponent {
        OWLAnnotationProperty property;
        Object content;

        public AnnotationComponent(OWLAnnotationProperty property, Object content) {
            this.property = property;
            this.content = content;
        }

        public OWLAnnotationProperty getProperty() {
            return this.property;
        }

        public Object getContent() {
            return this.content;
        }
    }

    public static class DataRangeComponent
    implements RestrictionComponent {
        public static final int ALL = 1;
        public static final int SOME = 2;
        OWLDataRange dataRange;
        int type;

        public DataRangeComponent(OWLDataRange dataRange, int type) {
            this.dataRange = dataRange;
            this.type = type;
        }

        public OWLDataRange getDataRange() {
            return this.dataRange;
        }

        public int getType() {
            return this.type;
        }
    }

    public static class DescriptionComponent
    implements RestrictionComponent {
        public static final int ALL = 1;
        public static final int SOME = 2;
        OWLDescription description;
        int type;

        public DescriptionComponent(OWLDescription description, int type) {
            this.description = description;
            this.type = type;
        }

        public OWLDescription getDescription() {
            return this.description;
        }

        public int getType() {
            return this.type;
        }
    }

    public static class IndividualValueComponent
    implements RestrictionComponent {
        URI value;

        public IndividualValueComponent(URI individualId) {
            this.value = individualId;
        }

        public URI getValue() {
            return this.value;
        }
    }

    public static class DataLiteralValueComponent
    implements RestrictionComponent {
        OWLDataValue dataLiteral;

        public DataLiteralValueComponent(OWLDataValue dataLiteral) {
            this.dataLiteral = dataLiteral;
        }

        public OWLDataValue getDataLiteral() {
            return this.dataLiteral;
        }
    }

    public static class CardinalityComponent
    implements RestrictionComponent {
        public static final int MAX = 1;
        public static final int MIN = 2;
        public static final int EQ = 3;
        int type;
        int cardinality;

        public CardinalityComponent(int type) {
            this.type = type;
        }

        public void setCardinality(String tokenValue) {
            try {
                this.cardinality = new Integer(tokenValue);
            }
            catch (NumberFormatException e) {
                throw new TokenNotNumberError((Throwable)e);
            }
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public int getType() {
            return this.type;
        }

        class TokenNotNumberError
        extends Error {
            TokenNotNumberError(Throwable e) {
                super(e);
            }
        }
    }

    public static class DataPropertyValue
    implements PropertyValue {
        OWLDataProperty property;
        OWLDataValue dataValue;

        public DataPropertyValue(OWLDataProperty property, OWLDataValue dataValue) {
            this.property = property;
            this.dataValue = dataValue;
        }

        public OWLDataProperty getProperty() {
            return this.property;
        }

        public OWLDataValue getDataValue() {
            return this.dataValue;
        }
    }

    public static class ObjectPropertyValue
    implements PropertyValue {
        OWLObjectProperty property;
        OWLIndividual individual;

        public ObjectPropertyValue(OWLObjectProperty property, OWLIndividual individual) {
            this.property = property;
            this.individual = individual;
        }

        public OWLObjectProperty getProperty() {
            return this.property;
        }

        public OWLIndividual getIndividual() {
            return this.individual;
        }
    }

    public static interface PropertyValue {
    }
}

