/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.model.helper;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFrame;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import org.semanticweb.owl.model.helper.OntologyHelper;

public class OWLEntityCollector
extends OWLObjectVisitorAdapter {
    static Logger logger = Logger.getLogger((Class)(class$org$semanticweb$owl$model$helper$OWLEntityCollector == null ? (class$org$semanticweb$owl$model$helper$OWLEntityCollector = OWLEntityCollector.class$("org.semanticweb.owl.model.helper.OWLEntityCollector")) : class$org$semanticweb$owl$model$helper$OWLEntityCollector));
    private Set entities;
    static /* synthetic */ Class class$org$semanticweb$owl$model$helper$OWLEntityCollector;

    public OWLEntityCollector() {
        this.reset();
    }

    public void reset() {
        this.entities = new HashSet();
    }

    public Set entities() {
        return new HashSet(this.entities);
    }

    public void visit(OWLAnd node) throws OWLException {
        Iterator it = node.getOperands().iterator();
        while (it.hasNext()) {
            OWLObject oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLDataAllRestriction node) throws OWLException {
        this.entities.add(node.getDataProperty());
    }

    public void visit(OWLDataCardinalityRestriction node) throws OWLException {
        this.entities.add(node.getDataProperty());
    }

    public void visit(OWLDataProperty node) throws OWLException {
        this.entities.add(node);
    }

    public void visit(OWLDataSomeRestriction node) throws OWLException {
        this.entities.add(node.getDataProperty());
    }

    public void visit(OWLDataValueRestriction node) throws OWLException {
        this.entities.add(node.getDataProperty());
    }

    public void visit(OWLDifferentIndividualsAxiom node) throws OWLException {
        Iterator it = node.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLObject oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLDisjointClassesAxiom node) throws OWLException {
        Iterator it = node.getDisjointClasses().iterator();
        while (it.hasNext()) {
            OWLObject oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLEquivalentClassesAxiom node) throws OWLException {
        Iterator it = node.getEquivalentClasses().iterator();
        while (it.hasNext()) {
            OWLObject oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLEquivalentPropertiesAxiom node) throws OWLException {
        Iterator it = node.getProperties().iterator();
        while (it.hasNext()) {
            OWLObject oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLFrame node) throws OWLException {
        OWLObject oo;
        Iterator it = node.getRestrictions().iterator();
        while (it.hasNext()) {
            oo = (OWLObject)it.next();
            oo.accept(this);
        }
        it = node.getSuperclasses().iterator();
        while (it.hasNext()) {
            oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLIndividual node) throws OWLException {
        this.entities.add(node);
    }

    public void visit(OWLObjectAllRestriction node) throws OWLException {
        this.entities.add(node.getObjectProperty());
        node.getDescription().accept(this);
    }

    public void visit(OWLObjectCardinalityRestriction node) throws OWLException {
        this.entities.add(node.getObjectProperty());
    }

    public void visit(OWLObjectProperty node) throws OWLException {
        this.entities.add(node);
    }

    public void visit(OWLObjectSomeRestriction node) throws OWLException {
        this.entities.add(node.getObjectProperty());
        node.getDescription().accept(this);
    }

    public void visit(OWLObjectValueRestriction node) throws OWLException {
        this.entities.add(node.getObjectProperty());
        this.entities.add(node.getIndividual());
    }

    public void visit(OWLNot node) throws OWLException {
        node.getOperand().accept(this);
    }

    public void visit(OWLOntology node) throws OWLException {
        Set allOntologies = OntologyHelper.importClosure(node);
        logger.debug((Object)node.getURI());
        Iterator it = allOntologies.iterator();
        while (it.hasNext()) {
            Object o;
            OWLOntology onto = (OWLOntology)it.next();
            Iterator cit = onto.getClasses().iterator();
            while (cit.hasNext()) {
                o = cit.next();
                this.entities.add(o);
                logger.debug(o);
            }
            cit = onto.getIndividuals().iterator();
            while (cit.hasNext()) {
                o = cit.next();
                this.entities.add(o);
                logger.debug(o);
            }
            cit = onto.getObjectProperties().iterator();
            while (cit.hasNext()) {
                o = cit.next();
                this.entities.add(o);
                logger.debug(o);
            }
            cit = onto.getDataProperties().iterator();
            while (cit.hasNext()) {
                o = cit.next();
                this.entities.add(o);
                logger.debug(o);
            }
        }
    }

    public void visit(OWLOr node) throws OWLException {
        Iterator it = node.getOperands().iterator();
        while (it.hasNext()) {
            OWLObject oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLClass node) throws OWLException {
        this.entities.add(node);
    }

    public void visit(OWLEnumeration node) throws OWLException {
        Iterator it = node.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLObject oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLSameIndividualsAxiom node) throws OWLException {
        Iterator it = node.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLObject oo = (OWLObject)it.next();
            oo.accept(this);
        }
    }

    public void visit(OWLSubClassAxiom node) throws OWLException {
        node.getSubClass().accept(this);
        node.getSuperClass().accept(this);
    }

    public void visit(OWLSubPropertyAxiom node) throws OWLException {
        node.getSubProperty().accept(this);
        node.getSuperProperty().accept(this);
    }

    public void visit(OWLAnnotationInstance node) throws OWLException {
        node.getProperty().accept(this);
    }

    public void visit(OWLAnnotationProperty node) throws OWLException {
        this.entities.add(node);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

