/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.LogicalURIResolver;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OntologyReplicator;
import org.semanticweb.owl.util.PhysicalURIToDefaultParametersResolver;

public class OWLManager {
    final int LOAD_CONCEPT_BASICS = 1;
    final int LOAD_SUPER_CONCEPTS = 2;
    final int LOAD_SUB_CONCEPTS = 4;
    final int LOAD_PROPERTIES_FROM = 8;
    final int LOAD_PROPERTIES_TO = 16;
    final int LOAD_CONCEPT_INSTANCES = 32;
    final int LOAD_CONCEPT_ALL = 63;
    final int LOAD_PROPERTY_BASICS = 64;
    final int LOAD_SUPER_PROPERTIES = 128;
    final int LOAD_SUB_PROPERTIES = 256;
    final int LOAD_PROPERTY_DOMAINS = 512;
    final int LOAD_PROPERTY_RANGES = 1024;
    final int LOAD_PROPERTY_INSTANCES = 2048;
    final int LOAD_PROPERTY_ALL = 4032;
    final int LOAD_INSTANCE_BASICS = 4096;
    final int LOAD_INSTANCE_PARENT_CONCEPTS = 8192;
    final int LOAD_INSTANCE_FROM_PROPERTY_VALUES = 16384;
    final int LOAD_INSTANCE_TO_PROPERTY_VALUES = 32768;
    final int LOAD_INSTANCE_ALL = 61440;
    final int LOAD_LEXICON = 65536;
    final int LOAD_ENTITY_ALL = 131071;
    public static final int CAPABILITY_ALWAYS_SAVED = 1;
    public static final int CAPABILITY_SUPPORTS_OPTIMIZED_LOADING = 2;
    public static final int CAPABILITY_SUPPORTS_NOTIFICATIONS = 4;
    public static final String OWL_CONNECTION = "OWL_CONNECTION";
    protected static final Class[] OWL_CONNECTION_PARAMETERS = new Class[]{class$java$util$Map == null ? (class$java$util$Map = OWLManager.class$("java.util.Map")) : class$java$util$Map};
    public static final Map s_parametersAPIOnRDF;
    protected static final Map s_physicalURIToDefaultParametersResolvers;
    protected static final List s_logicalURIResolvers;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$semanticweb$owl$util$OWLManager;

    public static void startOWLImplementation(String connectionClassName) throws OWLException {
        try {
            Class.forName(connectionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new OWLException("Cannot load OWL connection class '" + connectionClassName + "'", e);
        }
    }

    public static OWLConnection getOWLConnection(Map parameters) throws OWLException {
        String connectionClass = (String)parameters.get(OWL_CONNECTION);
        if (connectionClass == null) {
            throw new OWLException("Parameters must specify the connection class through 'KAON_CONNECTION' key.");
        }
        try {
            Class<?> clazz = Class.forName(connectionClass);
            Constructor<?> constructor = clazz.getConstructor(OWL_CONNECTION_PARAMETERS);
            Object object = constructor.newInstance(parameters);
            if (!(object instanceof OWLConnection)) {
                throw new OWLException("Supplied object is not a OWLConnection.");
            }
            return (OWLConnection)object;
        }
        catch (ClassNotFoundException e) {
            throw new OWLException("Cannot load KAON connection class '" + connectionClass + "'", e);
        }
        catch (NoSuchMethodException e) {
            throw new OWLException("Cannot instantiate KAON connection class '" + connectionClass + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new OWLException("Cannot instantiate KAON connection class '" + connectionClass + "'", e);
        }
        catch (InstantiationException e) {
            throw new OWLException("Cannot instantiate KAON connection class '" + connectionClass + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new OWLException("Cannot instantiate KAON connection class '" + connectionClass + "'", e);
        }
    }

    public static OWLConnection getOWLConnection() throws OWLException {
        OWLConnection connection = null;
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            String connectionImpl = System.getProperty("org.semanticweb.owl.util.OWLConnection");
            if (connectionImpl == null || connectionImpl.equals("")) {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(cl.getResourceAsStream("META-INF/services/org.semanticweb.owl.util.OWLConnection")));
                    connectionImpl = br.readLine();
                }
                catch (Exception e) {
                    connectionImpl = "org.semanticweb.owl.impl.model.OWLConnectionImpl";
                }
            }
            if (connectionImpl != null && !connectionImpl.equals("")) {
                parameters.put(OWL_CONNECTION, connectionImpl);
                connection = OWLManager.getOWLConnection(parameters);
            }
        }
        catch (Exception e) {
            throw new OWLException("Cannot create new connection: " + e.getMessage());
        }
        return connection;
    }

    public static synchronized Map getDefaultParametersForPhysicalURI(String physicalURI, Map contextParameters) throws OWLException {
        Iterator iterator = s_physicalURIToDefaultParametersResolvers.values().iterator();
        while (iterator.hasNext()) {
            PhysicalURIToDefaultParametersResolver resolver = (PhysicalURIToDefaultParametersResolver)iterator.next();
            Map parameters = resolver.getDefaultParametersForPhysicalURI(physicalURI, contextParameters);
            if (parameters == null) continue;
            return parameters;
        }
        throw new OWLException("Cannot resolve physical URI '" + physicalURI + "' to default parameters.");
    }

    public static synchronized void registerPhysicalURIToDefaultParametersResolver(PhysicalURIToDefaultParametersResolver resolver) {
        String className = resolver.getClass().getName();
        s_physicalURIToDefaultParametersResolvers.put(className, resolver);
    }

    public static synchronized void registerPhysicalURIToDefaultParametersResolver(String resolverClassName) throws OWLException {
        try {
            Class<?> clazz = Class.forName(resolverClassName);
            Object object = clazz.newInstance();
            if (!(object instanceof PhysicalURIToDefaultParametersResolver)) {
                throw new OWLException("Supplied object is not a PhysicalURIToDefaultParametersResolver");
            }
            OWLManager.registerPhysicalURIToDefaultParametersResolver((PhysicalURIToDefaultParametersResolver)object);
        }
        catch (ClassNotFoundException e) {
            throw new OWLException("Cannot load resolver class '" + resolverClassName + "'", e);
        }
        catch (InstantiationException e) {
            throw new OWLException("Cannot instantiate resolver class '" + resolverClassName + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new OWLException("Cannot instantiate resolver class '" + resolverClassName + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OWLOntology resolveLogicalURI(OWLConnection OWLConnection2, URI logicalURI) throws OWLException {
        ArrayList resolvers;
        Class clazz = class$org$semanticweb$owl$util$OWLManager == null ? (class$org$semanticweb$owl$util$OWLManager = OWLManager.class$("org.semanticweb.owl.util.OWLManager")) : class$org$semanticweb$owl$util$OWLManager;
        synchronized (clazz) {
            resolvers = new ArrayList(s_logicalURIResolvers);
        }
        for (int i = 0; i < resolvers.size(); ++i) {
            LogicalURIResolver resolver = (LogicalURIResolver)resolvers.get(i);
            LogicalURIResolver.ResultHolder result = resolver.resolveLogicalURI(logicalURI);
            if (result == null) continue;
            if (OWLManager.canUseConnectionForParameters(OWLConnection2, result.m_connectionParameters)) {
                return OWLConnection2.getOntologyPhysical(result.m_physicalURI);
            }
            OWLConnection sourceConnection = OWLManager.getOWLConnection(result.m_connectionParameters);
            try {
                OWLOntology sourceOIModel = sourceConnection.getOntologyPhysical(result.m_physicalURI);
                HashMap<URI, String> logicalToPhysicalURIsMap = new HashMap<URI, String>();
                logicalToPhysicalURIsMap.put(logicalURI, "");
                OntologyReplicator replicator = new OntologyReplicator(sourceOIModel, logicalToPhysicalURIsMap, OWLConnection2);
                try {
                    OWLOntology oWLOntology = replicator.doReplication();
                    return oWLOntology;
                }
                catch (InterruptedException error) {
                    throw new OWLException("Model replication interrupted", error);
                }
            }
            finally {
                sourceConnection.close();
            }
        }
        return null;
    }

    public static synchronized void registerLogicalURIResolver(LogicalURIResolver resolver) {
        s_logicalURIResolvers.add(resolver);
    }

    public static synchronized void unregisterLogicalURIResolver(LogicalURIResolver resolver) {
        s_logicalURIResolvers.remove(resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWellKnownRDFOntology(final URI wellKnownOIModelPhysicalURI) throws OWLException {
        String wellKnownOIModelLogicalURI;
        OWLConnection connection = OWLManager.getOWLConnection(s_parametersAPIOnRDF);
        try {
            OWLOntology oimodel = connection.getOntologyPhysical(wellKnownOIModelPhysicalURI);
            wellKnownOIModelLogicalURI = oimodel.getLogicalURI().toString();
        }
        finally {
            connection.close();
        }
        OWLManager.registerLogicalURIResolver(new LogicalURIResolver(){

            public LogicalURIResolver.ResultHolder resolveLogicalURI(URI logicalURI) {
                if (wellKnownOIModelLogicalURI.equals(logicalURI)) {
                    LogicalURIResolver.ResultHolder result = new LogicalURIResolver.ResultHolder();
                    result.m_physicalURI = wellKnownOIModelPhysicalURI;
                    result.m_connectionParameters = s_parametersAPIOnRDF;
                    return result;
                }
                return null;
            }
        });
    }

    public static boolean canUseConnectionForParameters(OWLConnection connection, Map parameters) {
        Map connectionParameters;
        try {
            connectionParameters = connection.getParameters();
        }
        catch (OWLException e) {
            return false;
        }
        Iterator keys = parameters.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!connectionParameters.containsKey(key)) {
                return false;
            }
            Object connectionValue = connectionParameters.get(key);
            Object parametersValue = parameters.get(key);
            if (!(connectionValue == null ? parametersValue != null : !connectionValue.equals(parametersValue) && !"???".equals(parametersValue))) continue;
            return false;
        }
        return true;
    }

    protected static void registerWellKnownRDFOntologyEx(URI wellKnownOIModelPhysicalURI) {
        try {
            OWLManager.registerWellKnownRDFOntology(wellKnownOIModelPhysicalURI);
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(OWL_CONNECTION, "edu.unika.aifb.owl.apionrdf.OWLConnectionImpl");
        s_parametersAPIOnRDF = Collections.unmodifiableMap(parameters);
        s_physicalURIToDefaultParametersResolvers = new HashMap();
        s_logicalURIResolvers = new ArrayList();
        try {
            OWLManager.startOWLImplementation("edu.unika.aifb.kaon.apionrdf.OWLConnectionImpl");
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
    }
}

