/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import org.mindswap.pellet.datatypes.ValueSpace;

public abstract class AbstractValueSpace
implements ValueSpace {
    public static final Integer EQ = 0;
    public static final Integer GT = 1;
    public static final Integer LT = -1;
    public static final Integer SIZE_ZERO = 1;
    public static final Integer SIZE_ONE = 1;
    public static final Integer SIZE_INF = -1;
    private Object minVal;
    private Object maxVal;
    private Object midVal;
    private boolean isInfinite;

    public AbstractValueSpace(Object minInf, Object midVal, Object maxInf, boolean isInfinite) {
        this.minVal = minInf;
        this.midVal = midVal;
        this.maxVal = maxInf;
        this.isInfinite = isInfinite;
    }

    public Object getMidValue() {
        return this.midVal;
    }

    public Object getMinValue() {
        return this.minVal;
    }

    public Object getMaxValue() {
        return this.maxVal;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    public boolean isInfinite(Object value) {
        return this.isInfinite && (this.minVal.equals(value) || this.maxVal.equals(value));
    }

    protected Integer compareInternal(Object o1, Object o2) {
        if (o1.equals(o2)) {
            return EQ;
        }
        if (this.minVal.equals(o1) || this.maxVal.equals(o2)) {
            return LT;
        }
        if (this.maxVal.equals(o1) || this.minVal.equals(o2)) {
            return GT;
        }
        return null;
    }

    protected Integer countInternal(Object o1, Object o2) {
        if (o1.equals(o2)) {
            return SIZE_ONE;
        }
        if (this.minVal.equals(o1) || this.maxVal.equals(o2)) {
            return SIZE_INF;
        }
        if (this.maxVal.equals(o1) || this.minVal.equals(o2)) {
            return SIZE_ZERO;
        }
        return null;
    }
}

