/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler;

import jjtraveler.FailAtNodes;
import jjtraveler.Identity;
import jjtraveler.Logger;
import jjtraveler.SpineTopDown;
import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.Visitor;
import jjtraveler.VisitorTestCase;
import junit.framework.Assert;

public class SpineTopDownTest
extends VisitorTestCase {
    public SpineTopDownTest(String test) {
        super(test);
    }

    public void testSpineTopDownAtInnerNode() throws VisitFailure {
        FailAtNodes stop = new FailAtNodes(this.n1);
        SpineTopDown spineTopDown = new SpineTopDown(this.logVisitor(stop));
        Logger expected = new Logger((Visitor)stop, new Visitable[]{this.n0, this.n1, this.n2});
        Visitable nodeReturned = spineTopDown.visit(this.n0);
        Assert.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
        Assert.assertEquals((String)"return value", (Object)this.n0, (Object)nodeReturned);
    }

    public void testSpineTopDownAtLeaf() throws VisitFailure {
        FailAtNodes stop = new FailAtNodes(this.n11);
        SpineTopDown spineTopDown = new SpineTopDown(this.logVisitor(stop));
        Logger expected = new Logger((Visitor)stop, new Visitable[]{this.n0, this.n1, this.n11, this.n12});
        Visitable nodeReturned = spineTopDown.visit(this.n0);
        Assert.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
        Assert.assertEquals((String)"return value", (Object)this.n0, (Object)nodeReturned);
    }

    public void testSpineTopDownOnlySuccess() throws VisitFailure {
        Identity dontStop = new Identity();
        SpineTopDown spineTopDown = new SpineTopDown(this.logVisitor(dontStop));
        Logger expected = new Logger((Visitor)dontStop, new Visitable[]{this.n0, this.n1, this.n11});
        Visitable nodeReturned = spineTopDown.visit(this.n0);
        Assert.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
        Assert.assertEquals((String)"return value", (Object)this.n0, (Object)nodeReturned);
    }

    public void testSpineTopDownFailAtTop() {
        FailAtNodes stop = new FailAtNodes(this.n0);
        SpineTopDown spineTopDown = new SpineTopDown(this.logVisitor(stop));
        Logger expected = new Logger((Visitor)stop, new Visitable[]{this.n0});
        Visitable nodeReturned = null;
        try {
            nodeReturned = spineTopDown.visit(this.n0);
            Assert.fail((String)"VisitFailure should have occured!");
        }
        catch (VisitFailure vf) {
            Assert.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
            Assert.assertNull((String)"return value", (Object)nodeReturned);
        }
    }

    public void testSpineTopDownFailAtInners() {
        FailAtNodes stop = new FailAtNodes(this.n1, this.n2);
        SpineTopDown spineTopDown = new SpineTopDown(this.logVisitor(stop));
        Logger expected = new Logger((Visitor)stop, new Visitable[]{this.n0, this.n1, this.n2});
        Visitable nodeReturned = null;
        try {
            nodeReturned = spineTopDown.visit(this.n0);
            Assert.fail((String)"VisitFailure should have occured!");
        }
        catch (VisitFailure vf) {
            Assert.assertEquals((String)"visit trace", (Object)expected, (Object)this.logger);
            Assert.assertNull((String)"return value", (Object)nodeReturned);
        }
    }
}

