/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core.describe;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandler;
import com.hp.hpl.jena.sparql.util.Closure;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.Iterator;

public class DescribeBNodeClosure
implements DescribeHandler {
    Model acc;
    Dataset dataset;

    public void start(Model accumulateResultModel, Context cxt) {
        this.acc = accumulateResultModel;
        this.dataset = (Dataset)cxt.get(ARQConstants.sysCurrentDataset);
    }

    public void describe(Resource r) {
        Closure.closure(DescribeBNodeClosure.otherModel(r, this.dataset.getDefaultModel()), false, this.acc);
        Iterator<String> iter = this.dataset.listNames();
        while (iter.hasNext()) {
            String name = iter.next();
            Model model = this.dataset.getNamedModel(name);
            Resource r2 = DescribeBNodeClosure.otherModel(r, model);
            Closure.closure(r2, false, this.acc);
        }
        Closure.closure(r, false, this.acc);
    }

    private static Resource otherModel(Resource r, Model model) {
        if (r.isURIResource()) {
            return model.createResource(r.getURI());
        }
        if (r.isAnon()) {
            return model.createResource(r.getId());
        }
        return r;
    }

    public void finish() {
    }
}

