/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.util.Symbol;
import com.hp.hpl.jena.query.util.TranslationTable;

public class Syntax
extends Symbol {
    public static final Syntax syntaxSPARQL = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL");
    public static final Syntax syntaxSPARQLdev = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQLdev");
    public static final Syntax syntaxARQ = new Syntax("http://jena.hpl.hp.com/2003/07/query/ARQ");
    public static final Syntax syntaxRDQL = new Syntax("http://jena.hpl.hp.com/2003/07/query/RDQL");
    public static final Syntax syntaxSPARQL_X = new Syntax("http://jena.hpl.hp.com/2003/07/query/SPARQL-X");
    public static final Syntax syntaxPrefix = new Syntax("http://jena.hpl.hp.com/2003/07/query/prefix");
    public static final Syntax syntaxDebug = new Syntax("http://jena.hpl.hp.com/2003/07/query/debug");
    public static final Syntax syntaxN3QL = new Syntax("http://jena.hpl.hp.com/2003/07/query/N3QL");
    public static TranslationTable querySyntaxNames = new TranslationTable(true);
    public static Syntax defaultSyntax;

    protected Syntax(String s) {
        super(s);
    }

    protected Syntax(Syntax s) {
        super(s);
    }

    public static Syntax make(String uri) {
        if (uri == null) {
            return null;
        }
        Symbol sym = new Symbol(uri);
        if (sym.equals(syntaxARQ)) {
            return syntaxARQ;
        }
        if (sym.equals(syntaxRDQL)) {
            return syntaxRDQL;
        }
        if (sym.equals(syntaxSPARQL)) {
            return syntaxSPARQL;
        }
        if (sym.equals(syntaxSPARQL_X)) {
            return syntaxSPARQL_X;
        }
        if (sym.equals(syntaxPrefix)) {
            return syntaxPrefix;
        }
        if (sym.equals(syntaxDebug)) {
            return syntaxDebug;
        }
        if (sym.equals(syntaxN3QL)) {
            return syntaxN3QL;
        }
        return null;
    }

    public static Syntax guessQueryFileSyntax(String url) {
        return Syntax.guessQueryFileSyntax(url, syntaxSPARQL);
    }

    public static Syntax guessQueryFileSyntax(String url, Syntax defaultSyntax) {
        if (url.endsWith(".arq")) {
            return syntaxARQ;
        }
        if (url.endsWith(".rq")) {
            return syntaxSPARQL;
        }
        if (url.endsWith(".rqp")) {
            return syntaxPrefix;
        }
        if (url.endsWith(".rqx")) {
            return syntaxSPARQL_X;
        }
        if (url.endsWith(".rdql")) {
            return syntaxRDQL;
        }
        return defaultSyntax;
    }

    public static Syntax lookup(String s) {
        return (Syntax)querySyntaxNames.lookup(s);
    }

    static {
        querySyntaxNames.put("sparql", syntaxSPARQL);
        querySyntaxNames.put("sparqldev", syntaxSPARQLdev);
        querySyntaxNames.put("sparql-x", syntaxSPARQL_X);
        querySyntaxNames.put("arq", syntaxARQ);
        querySyntaxNames.put("rdql", syntaxRDQL);
        querySyntaxNames.put("n3ql", syntaxN3QL);
        querySyntaxNames.put("prefix", syntaxPrefix);
        querySyntaxNames.put("debug", syntaxDebug);
        querySyntaxNames.put("plain", syntaxDebug);
        defaultSyntax = syntaxSPARQL;
    }
}

