/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.LabelMap;
import com.hp.hpl.jena.query.core.TripleCollector;
import com.hp.hpl.jena.query.core.Var;
import java.util.ArrayList;
import java.util.List;

public class ElementBasicGraphPattern
extends Element
implements TripleCollector {
    private List triples = new ArrayList();

    public boolean isEmpty() {
        return this.triples.size() == 0;
    }

    public void addTriple(Triple t) {
        this.triples.add(t);
    }

    public int mark() {
        return this.triples.size();
    }

    public void addTriple(int index, Triple t) {
        this.triples.add(index, t);
    }

    public List getTriples() {
        return this.triples;
    }

    public int hashCode() {
        int calcHashCode = 161;
        return calcHashCode ^= ((Object)this.getTriples()).hashCode();
    }

    public boolean equalTo(Element el2, LabelMap labelMap) {
        if (el2 == null) {
            return false;
        }
        if (!(el2 instanceof ElementBasicGraphPattern)) {
            return false;
        }
        ElementBasicGraphPattern eg2 = (ElementBasicGraphPattern)el2;
        if (this.getTriples().size() != eg2.getTriples().size()) {
            return false;
        }
        for (int i = 0; i < this.getTriples().size(); ++i) {
            Triple t2;
            Triple t1 = (Triple)this.getTriples().get(i);
            if (ElementBasicGraphPattern.equalTo(t1, t2 = (Triple)eg2.getTriples().get(i), labelMap)) continue;
            return false;
        }
        return true;
    }

    public void visit(ElementVisitor v) {
        v.visit(this);
    }

    private static boolean equalTo(Triple t1, Triple t2, LabelMap labelMap) {
        Node s1 = t1.getSubject();
        Node p1 = t1.getPredicate();
        Node o1 = t1.getObject();
        Node s2 = t2.getSubject();
        Node p2 = t2.getPredicate();
        Node o2 = t2.getObject();
        if (!ElementBasicGraphPattern.nodeEquals(s1, s2, labelMap)) {
            return false;
        }
        if (!ElementBasicGraphPattern.nodeEquals(p1, p2, labelMap)) {
            return false;
        }
        return ElementBasicGraphPattern.nodeEquals(o1, o2, labelMap);
    }

    private static boolean nodeEquals(Node n1, Node n2, LabelMap labelMap) {
        if (Var.isBlankNodeVar(n1) && Var.isBlankNodeVar(n2)) {
            String label1 = n1.getName();
            String label2 = n2.getName();
            String maybe = labelMap.get(label1);
            if (maybe == null) {
                labelMap.put(label1, label2);
                return true;
            }
            return maybe.equals(label2);
        }
        return n1.equals((Object)n2);
    }
}

