/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.QuerySolutionBase;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingBase;
import com.hp.hpl.jena.query.util.NodeUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.ArrayList;
import java.util.Iterator;

public class ResultBinding
extends QuerySolutionBase {
    Binding binding;
    Model model;

    public ResultBinding(Model _model, Binding _binding) {
        this.model = _model;
        this.binding = _binding;
    }

    public RDFNode _get(String varName) {
        Node n = this.getNode(varName);
        if (n == null) {
            return null;
        }
        return NodeUtils.convertGraphNodeToRDFNode(n, this.model);
    }

    private Node getNode(String varName) {
        return this.binding.get(Var.alloc(varName));
    }

    public boolean _contains(String varName) {
        return this.binding.contains(Var.alloc(varName));
    }

    public Iterator varNames() {
        ArrayList<String> x = new ArrayList<String>();
        Iterator iter = this.binding.vars();
        while (iter.hasNext()) {
            Var v = (Var)((Object)iter.next());
            x.add(v.getVarName());
        }
        return x.iterator();
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String toString() {
        if (this.binding == null) {
            return "<no binding>";
        }
        return this.binding.toString();
    }

    public static boolean same(ResultBinding rb1, ResultBinding rb2) {
        return BindingBase.same(rb1.getBinding(), rb2.getBinding());
    }
}

