/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BindingBase
implements Binding {
    static Log log = LogFactory.getLog((Class)BindingBase.class);
    static boolean CHECKING = true;
    static boolean UNIQUE_NAMES_CHECK = true;
    Binding parent;
    List children = new ArrayList();

    protected BindingBase(Binding _parent) {
        this.parent = _parent;
    }

    public Iterator getChildren() {
        return this.children.listIterator();
    }

    public Binding getParent() {
        return this.parent;
    }

    private void addChild(BindingBase child) {
        this.children.add(child);
    }

    public final void add(Var var, Node node) {
        if (node == null) {
            log.warn((Object)"Binding.add: null value - ignored");
            return;
        }
        this.checkAdd(var, node);
        this.add1(var, node);
    }

    protected abstract void add1(Var var1, Node var2);

    public final Iterator vars() {
        Iterator iter = this.vars1();
        if (this.parent != null) {
            iter = new ConcatenatedIterator(this.parent.vars(), iter);
        }
        return iter;
    }

    protected abstract Iterator vars1();

    public boolean contains(Var var) {
        if (this.contains1(var)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.contains(var);
    }

    protected abstract boolean contains1(Var var1);

    public final Node get(Var var) {
        Node node = this.get1(var);
        if (node != null) {
            return node;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.get(var);
    }

    protected abstract Node get1(Var var1);

    public String toString() {
        String tmp;
        StringBuffer sbuff = new StringBuffer();
        this.format1(sbuff);
        if (this.parent != null && (tmp = this.parent.toString()) != null && tmp.length() != 0) {
            sbuff.append(" -> ");
            sbuff.append(tmp);
        }
        return sbuff.toString();
    }

    public void format1(StringBuffer sbuff) {
        String sep = "";
        Iterator iter = this.vars1();
        while (iter.hasNext()) {
            Object obj = iter.next();
            Var var = (Var)((Object)obj);
            if (Var.isSystemVar((Node)var)) continue;
            sbuff.append(sep);
            sep = " ";
            this.format(sbuff, var);
        }
    }

    protected void format(StringBuffer sbuff, Var var) {
        Node node = this.get(var);
        String tmp = FmtUtils.stringForObject(node);
        sbuff.append("( ?" + var.getVarName() + " = " + tmp + " )");
    }

    public String toString1() {
        StringBuffer sbuff = new StringBuffer();
        this.format1(sbuff);
        return sbuff.toString();
    }

    private void checkAdd(Var var, Node node) {
        if (!CHECKING) {
            return;
        }
        if (node == null) {
            log.warn((Object)("check(" + (Object)((Object)var) + ", " + node + "): null node value"));
        }
        if (UNIQUE_NAMES_CHECK && this.get(var) != null) {
            log.warn((Object)("check(" + (Object)((Object)var) + ", " + node + "): Duplicate variable: " + (Object)((Object)var)));
        }
        this.checkAdd1(var, node);
    }

    protected abstract void checkAdd1(Var var1, Node var2);

    public static boolean same(Binding bind1, Binding bind2) {
        Iterator iter1 = bind1.vars();
        while (iter1.hasNext()) {
            Var var = (Var)((Object)iter1.next());
            Node n1 = bind1.get(var);
            Node n2 = bind2.get(var);
            if (n1 == null && n2 == null) continue;
            if (n1 == null) {
                return false;
            }
            if (n2 == null) {
                return false;
            }
            if (n1.equals((Object)n2)) continue;
            return false;
        }
        Iterator iter2 = bind2.vars();
        while (iter2.hasNext()) {
            Var var = (Var)((Object)iter1.next());
            if (bind1.contains(var)) continue;
            return false;
        }
        return true;
    }
}

