/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingBase;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterConvert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BindingImmutable
extends BindingBase {
    List vars;
    List values;
    private int calcHashCode;

    private BindingImmutable(Collection projectVars, Binding original) {
        super(null);
        this.vars = new ArrayList(projectVars.size());
        this.values = new ArrayList(projectVars.size());
        this.calcHashCode = 0;
        Iterator iter = projectVars.iterator();
        while (iter.hasNext()) {
            Var var = (Var)((Object)iter.next());
            Node n = original.get(var);
            this.vars.add(var);
            this.values.add(n);
            if (n == null) continue;
            this.calcHashCode = this.calcHashCode ^ n.hashCode() ^ var.hashCode();
        }
    }

    protected void add1(Var var, Node node) {
        throw new UnsupportedOperationException("BindingImmutable.add");
    }

    protected Iterator vars1() {
        return this.vars.listIterator();
    }

    protected boolean contains1(Var var) {
        Node tmp = this.get1(var);
        return tmp != null;
    }

    protected Node get1(Var var) {
        int i = this.vars.indexOf((Object)var);
        if (i < 0) {
            return null;
        }
        return (Node)this.values.get(i);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BindingImmutable)) {
            return false;
        }
        BindingImmutable b = (BindingImmutable)obj;
        if (b.hashCode() != this.hashCode()) {
            return false;
        }
        if (this.vars.size() != b.vars.size()) {
            return false;
        }
        ListIterator iter = this.vars.listIterator();
        while (iter.hasNext()) {
            Var v = (Var)((Object)iter.next());
            Node node1 = this.get(v);
            Node node2 = b.get(v);
            if (node1 == null && node2 == null) continue;
            if (node1 == null) {
                return false;
            }
            if (node2 == null) {
                return false;
            }
            if (node1.equals((Object)node2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.calcHashCode;
    }

    protected void checkAdd1(Var v, Node node) {
    }

    public static QueryIterator create(Collection vars, QueryIterator cIter, ExecutionContext context) {
        return new QueryIterConvert(cIter, new Convert(vars), context);
    }

    public static class Convert
    implements QueryIterConvert.Converter {
        Collection vars;

        public Convert(Collection vars) {
            this.vars = vars;
        }

        public Binding convert(Binding binding) {
            return new BindingImmutable(this.vars, binding);
        }
    }
}

