/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.engine.QueryEngineFactory;
import com.hp.hpl.jena.query.engine1.DefaultEngineFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class QueryEngineRegistry {
    List factories = new ArrayList();
    static QueryEngineRegistry registry;

    public static QueryEngineRegistry get() {
        if (registry == null) {
            QueryEngineRegistry.init();
        }
        return registry;
    }

    private QueryEngineRegistry() {
    }

    private static void init() {
        registry = new QueryEngineRegistry();
        DefaultEngineFactory.register(registry);
    }

    public static QueryEngineFactory findFactory(Query query, Dataset dataset) {
        return QueryEngineRegistry.get().find(query, dataset);
    }

    public QueryEngineFactory find(Query query, Dataset dataset) {
        ListIterator iter = this.factories.listIterator();
        while (iter.hasNext()) {
            QueryEngineFactory f = (QueryEngineFactory)iter.next();
            if (!f.accept(query, dataset)) continue;
            return f;
        }
        return null;
    }

    public static void addFactory(QueryEngineFactory f) {
        QueryEngineRegistry.get().add(f);
    }

    public void add(QueryEngineFactory f) {
        this.factories.add(0, f);
    }

    public static void removeFactory(QueryEngineFactory f) {
        QueryEngineRegistry.get().remove(f);
    }

    public void remove(QueryEngineFactory f) {
        this.factories.remove(f);
    }

    public List factories() {
        return this.factories;
    }

    public static boolean containsFactory(QueryEngineFactory f) {
        return QueryEngineRegistry.get().contains(f);
    }

    public boolean contains(QueryEngineFactory f) {
        return this.factories.contains(f);
    }

    static {
        QueryEngineRegistry.init();
        registry = null;
    }
}

