/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.core.DataSourceGraphImpl;
import com.hp.hpl.jena.query.core.DataSourceImpl;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.engine.QueryEngineFactory;
import com.hp.hpl.jena.query.engine.QueryEngineRegistry;
import com.hp.hpl.jena.query.engine.QueryExecutionGraph;
import java.util.Iterator;

public class QueryExecutionGraphFactory {
    public static QueryExecutionGraph create(String queryStr, Graph graph) {
        return QueryExecutionGraphFactory.create(QueryFactory.create(queryStr), graph);
    }

    public static QueryExecutionGraph create(String queryStr, DatasetGraph dataset) {
        return QueryExecutionGraphFactory.create(QueryFactory.create(queryStr), dataset);
    }

    public static QueryExecutionGraph create(Query query, Graph graph) {
        return QueryExecutionGraphFactory.make(query, new DataSourceGraphImpl(graph));
    }

    public static QueryExecutionGraph create(Query query, DatasetGraph dataset) {
        return QueryExecutionGraphFactory.make(query, dataset);
    }

    private static QueryExecutionGraph make(Query query, DatasetGraph datasetGraph) {
        DataSourceImpl dataset = new DataSourceImpl(datasetGraph);
        Iterator iter = QueryEngineRegistry.get().factories().iterator();
        while (iter.hasNext()) {
            QueryExecution obj;
            QueryEngineFactory f = (QueryEngineFactory)iter.next();
            if (!f.accept(query, dataset) || !((obj = f.create(query, dataset)) instanceof QueryExecutionGraph)) continue;
            return (QueryExecutionGraph)((Object)obj);
        }
        return null;
    }
}

