/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.LogFactory;

public class ExecCtl {
    private Context context = null;
    private DatasetGraph dataset = null;
    private Query query = null;
    private Collection openIterators = null;
    private Collection allIterators = null;

    protected ExecCtl(Context context) {
        this.context = context;
    }

    protected ExecCtl(ExecCtl other) {
        this.context = other.context;
        this.dataset = other.dataset;
        this.query = other.query;
        this.openIterators = other.openIterators;
        this.allIterators = other.allIterators;
    }

    protected ExecCtl(ExecCtl other, DatasetGraph dataset) {
        this.context = other.context;
        this.dataset = dataset;
        this.query = other.query;
        this.openIterators = other.openIterators;
        this.allIterators = other.allIterators;
    }

    public ExecCtl(Context params, Query query, DatasetGraph dataset) {
        this.context = params;
        this.dataset = dataset;
        this.query = query;
        this.openIterators = new ArrayList();
        this.allIterators = new ArrayList();
    }

    public Context getContext() {
        return this.context;
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    public Query getQuery() {
        return this.query;
    }

    public void openIterator(QueryIterator qIter) {
        this.openIterators.add(qIter);
        this.allIterators.add(qIter);
    }

    public void closedIterator(QueryIterator qIter) {
        this.openIterators.remove(qIter);
    }

    public Iterator listOpenIterators() {
        return this.openIterators.iterator();
    }

    public Iterator listAllIterators() {
        return this.allIterators.iterator();
    }

    public void dump() {
        this.dump(false);
    }

    public void dump(boolean includeAll) {
        if (includeAll) {
            Iterator iterAll = this.listAllIterators();
            while (iterAll.hasNext()) {
                QueryIterator qIter = (QueryIterator)iterAll.next();
                this.warn(qIter, "Iterator: ");
            }
        }
        Iterator iterOpen = this.listOpenIterators();
        while (iterOpen.hasNext()) {
            QueryIterator qIterOpen = (QueryIterator)iterOpen.next();
            this.warn(qIterOpen, "Open iterator: ");
        }
    }

    private void warn(QueryIterator qIter, String str) {
        LogFactory.getLog((Class)ExecCtl.class).warn((Object)(str + Utils.className(qIter)));
    }
}

