/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingMap;
import com.hp.hpl.jena.query.util.NodeUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngineUtils {
    public static Log log = LogFactory.getLog((Class)QueryEngineUtils.class);

    public static void compilePattern(Query graphQuery, List pattern, Binding presets, Set vars) {
        if (pattern == null) {
            return;
        }
        ListIterator iter = pattern.listIterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            t = QueryEngineUtils.substituteIntoTriple(t, presets);
            if (vars != null) {
                if (t.getSubject().isVariable()) {
                    vars.add(t.getSubject());
                }
                if (t.getPredicate().isVariable()) {
                    vars.add(t.getPredicate());
                }
                if (t.getObject().isVariable()) {
                    vars.add(t.getObject());
                }
            }
            graphQuery.addMatch(t);
        }
    }

    public static void compileConstraints(Query graphQuery, List constraints) {
        log.warn((Object)"Call to compileConstraints for Jena Expressions");
    }

    public static Triple substituteIntoTriple(Triple t, Binding binding) {
        Node subject = QueryEngineUtils.substituteNode(t.getSubject(), binding);
        Node predicate = QueryEngineUtils.substituteNode(t.getPredicate(), binding);
        Node object = QueryEngineUtils.substituteNode(t.getObject(), binding);
        if (subject == t.getSubject() && predicate == t.getPredicate() && object == t.getObject()) {
            return t;
        }
        return new Triple(subject, predicate, object);
    }

    public static Node substituteNode(Node n, Binding binding) {
        if (!n.isVariable()) {
            return n;
        }
        if (!(n instanceof Var)) {
            log.fatal((Object)"Node_Variable, not a Var");
        }
        Var var = Var.alloc(n);
        Node obj = null;
        if (binding != null) {
            obj = binding.get(var);
        }
        if (obj == null) {
            return n;
        }
        if (obj instanceof Node) {
            return obj;
        }
        log.warn((Object)("Unknown object in binding: ignored: " + obj.getClass().getName()));
        return n;
    }

    public static Node[] projectionVars(Set vars) {
        Node[] result = new Node[vars.size()];
        int i = 0;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Node n;
            result[i] = n = (Node)iter.next();
            ++i;
        }
        return result;
    }

    public static Statement tripleToStatement(Model model, Triple t) {
        Node sNode = t.getSubject();
        Node pNode = t.getPredicate();
        Node oNode = t.getObject();
        if (sNode.isLiteral() || sNode.isVariable()) {
            return null;
        }
        if (!pNode.isURI()) {
            return null;
        }
        if (oNode.isVariable()) {
            return null;
        }
        RDFNode s = NodeUtils.convertGraphNodeToRDFNode(sNode, model);
        RDFNode p = NodeUtils.convertGraphNodeToRDFNode(pNode, model);
        if (p instanceof Resource) {
            p = model.createProperty(((Resource)p).getURI());
        }
        RDFNode o = NodeUtils.convertGraphNodeToRDFNode(oNode, model);
        Statement stmt = model.createStatement((Resource)s, (Property)p, o);
        return stmt;
    }

    public static Binding asBinding(QuerySolution qSolution) {
        BindingMap binding = new BindingMap(null);
        QueryEngineUtils.addToBinding(binding, qSolution);
        return binding;
    }

    public static void addToBinding(Binding binding, QuerySolution qSolution) {
        Iterator iter = qSolution.varNames();
        while (iter.hasNext()) {
            String n = (String)iter.next();
            RDFNode x = qSolution.get(n);
            binding.add(Var.alloc(n), x.asNode());
        }
    }
}

