/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.analyse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitorBase;
import com.hp.hpl.jena.query.engine1.PlanWalker;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanGroup;
import com.hp.hpl.jena.query.engine1.plan.PlanNamedGraph;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class PlanVarsMentioned
extends PlanVisitorBase {
    public static Set varMentioned(PlanElement planElt) {
        HashSet acc = new HashSet();
        Visitor v = new Visitor(acc);
        PlanWalker.walk(planElt, v);
        return acc;
    }

    static class Visitor
    extends PlanVisitorBase {
        Set acc;

        public Visitor(Set s) {
            this.acc = s;
        }

        public void visit(PlanBlockTriples planElt) {
            ListIterator iter = planElt.triples();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                Visitor.addVarsFromTriple(this.acc, t);
            }
        }

        public void visit(PlanGroup planElt) {
        }

        public void visit(PlanFilter planElt) {
            planElt.getExpr().varsMentioned(this.acc);
        }

        public void visit(PlanNamedGraph planElt) {
            Visitor.addVar(this.acc, planElt.getGraphNameNode());
        }

        private static void addVarsFromTriple(Set acc, Triple t) {
            Visitor.addVar(acc, t.getSubject());
            Visitor.addVar(acc, t.getPredicate());
            Visitor.addVar(acc, t.getObject());
        }

        private static void addVar(Set acc, Node n) {
            if (n == null) {
                return;
            }
            if (n.isVariable()) {
                acc.add(n.getName());
            }
        }
    }
}

