/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.compiler;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.compiler.JenaVar;
import com.hp.hpl.jena.query.engine1.compiler.PatternLiteralImpl;
import com.hp.hpl.jena.query.expr.E_Regex;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.RegexEngine;
import com.hp.hpl.jena.query.util.Utils;
import com.hp.hpl.jena.shared.JenaException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JenaRegex
implements Expression,
Valuator {
    private static Log log = LogFactory.getLog((Class)JenaRegex.class);
    public static String regexSystem = "urn:x-jena:expr:Q_StringMatch";
    public static String regexLanguage = "http://jena.hpl.hp.com/2003/07/query/RDQL";
    E_Regex regex;
    JenaVar var;
    PatternLiteralImpl patternLiteral;

    JenaRegex(E_Regex regex, String var, String pat, String flags) {
        if (flags == null) {
            flags = "";
        }
        this.regex = regex;
        this.var = new JenaVar(var);
        this.patternLiteral = new PatternLiteralImpl(pat, flags);
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return regexSystem;
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0) {
            return this.var;
        }
        if (i == 1) {
            return this.patternLiteral;
        }
        return null;
    }

    public boolean isVariable() {
        return false;
    }

    public String getName() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public Valuator prepare(VariableIndexes vi) {
        this.var.prepare(vi);
        this.patternLiteral.prepare(vi);
        return this;
    }

    public Object evalObject(IndexValues iv) {
        log.warn((Object)("Unexpexpected call to " + Utils.className(this) + ".evalObject - expected only evalBool calls"));
        boolean b = this.evalBool(iv);
        return new Boolean(b);
    }

    public boolean evalBool(IndexValues iv) {
        Object obj = this.var.evalObject(iv);
        Node n = (Node)obj;
        if (log.isDebugEnabled()) {
            log.debug((Object)("evalBool " + this.patternLiteral.getPatternString() + " // " + n));
        }
        if (!n.isLiteral()) {
            return false;
        }
        if (n.getLiteralDatatypeURI() != null) {
            return false;
        }
        if (n.getLiteralLanguage() != null && !n.getLiteralLanguage().equals("")) {
            return false;
        }
        RegexEngine engine = null;
        try {
            engine = E_Regex.makeRegexEngine(this.patternLiteral.getPatternString(), this.patternLiteral.getPatternModifiers());
        }
        catch (Exception pEx) {
            throw new JenaException("JenaRegex: Pattern exception: " + pEx);
        }
        String xx = n.getLiteralLexicalForm();
        boolean b = engine.match(xx);
        return b;
    }

    private static int getMask(String mod) {
        if (mod == null) {
            return 0;
        }
        int mask = 0;
        block5: for (int i = 0; i < mod.length(); ++i) {
            switch (mod.charAt(i)) {
                case 'i': {
                    mask |= 0x40;
                    mask |= 2;
                    continue block5;
                }
                case 'm': {
                    mask |= 8;
                    continue block5;
                }
                case 's': {
                    mask |= 0x20;
                }
            }
        }
        return mask;
    }

    public boolean isSatisfied(Binding binding, ExecutionContext execCxt) {
        return this.regex.isSatisfied(binding, execCxt);
    }

    public void varsMentioned(Collection acc) {
        acc.add(this.var.getName());
    }

    public String toString() {
        return this.regex.toString();
    }

    public boolean isExpr() {
        return false;
    }

    public Expr getExpr() {
        return null;
    }
}

