/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.iterator;

import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine.QueryIteratorBase;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterTracked;
import com.hp.hpl.jena.query.util.Utils;

public abstract class QueryIter
extends QueryIteratorBase
implements QueryIterator {
    static volatile int iteratorCounter = 0;
    private int iteratorNumber = iteratorCounter++;
    private ExecutionContext tracker;

    public QueryIter(ExecutionContext qCxt) {
        this.tracker = qCxt;
        this.register();
    }

    public static QueryIter makeTracked(QueryIterator qIter, ExecutionContext qCxt) {
        if (qIter instanceof QueryIter) {
            return (QueryIter)qIter;
        }
        return new QueryIterTracked(qIter, qCxt);
    }

    public final void close() {
        super.close();
        this.deregister();
    }

    public ExecutionContext getExecContext() {
        return this.tracker;
    }

    public String toString() {
        return Utils.className(this);
    }

    public int getIteratorNumber() {
        return this.iteratorNumber;
    }

    private void register() {
        if (this.tracker != null) {
            this.tracker.openIterator(this);
        }
    }

    private void deregister() {
        if (this.tracker != null) {
            this.tracker.closedIterator(this);
        }
    }
}

