/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.iterator;

import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterFilter;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterConstraintFilter
extends QueryIterFilter {
    private static Log log = LogFactory.getLog((Class)QueryIterConstraintFilter.class);
    Expr expr;

    public QueryIterConstraintFilter(QueryIterator input, Expr expr, ExecutionContext context) {
        super(input, context);
        this.expr = expr;
    }

    public boolean accept(Binding binding) {
        boolean passFilter = false;
        try {
            Binding b = binding;
            passFilter = this.expr.isSatisfied(b, this.getExecContext());
        }
        catch (ExprException ex) {
            passFilter = false;
        }
        catch (Exception ex) {
            passFilter = false;
            log.warn((Object)("General exception in " + this.expr), (Throwable)ex);
        }
        if (!passFilter) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reject: " + this.expr + " - " + binding));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accept: " + this.expr + " - " + binding));
        }
        return true;
    }
}

