/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.compiler.PFuncOps;
import com.hp.hpl.jena.query.engine1.plan.PlanBlockTriples;
import com.hp.hpl.jena.query.engine1.plan.PlanElementN;
import com.hp.hpl.jena.query.engine1.plan.PlanUtils;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanBasicGraphPattern
extends PlanElementN {
    private static Log log = LogFactory.getLog((Class)PlanBasicGraphPattern.class);

    public static PlanElement make(Context context, ElementBasicGraphPattern bgp) {
        return new PlanBasicGraphPattern(context, bgp);
    }

    public PlanBasicGraphPattern(Context context) {
        this(context, (List)null);
    }

    private PlanBasicGraphPattern(Context context, ElementBasicGraphPattern bgp) {
        this(context, PlanBasicGraphPattern.process(context, bgp));
    }

    private PlanBasicGraphPattern(Context context, List readyMadePlanElements) {
        super(context, readyMadePlanElements);
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        return PlanUtils.buildSerial(this, input, execCxt);
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform, List newSubElements) {
        return transform.transform(this, newSubElements);
    }

    public PlanElement copy(List newSubElements) {
        return new PlanBasicGraphPattern(this.getContext(), newSubElements);
    }

    private static List process(Context context, ElementBasicGraphPattern bgp) {
        boolean doingMagicProperties = context.isTrue(ARQ.enablePropertyFunctions);
        PropertyFunctionRegistry registry = PFuncOps.chooseRegistry(context);
        ArrayList planBGPElements = new ArrayList();
        ArrayList propertyFunctionTriples = new ArrayList();
        ArrayList triples = new ArrayList();
        PlanBasicGraphPattern.findPropetryFunctions(context, bgp, doingMagicProperties, registry, triples, propertyFunctionTriples);
        HashMap pfPlanElts = new HashMap();
        PlanBasicGraphPattern.makePropetryFunctions(context, registry, pfPlanElts, triples, propertyFunctionTriples);
        PlanBasicGraphPattern.makePlanElements(context, planBGPElements, pfPlanElts, triples, propertyFunctionTriples);
        return planBGPElements;
    }

    private static void findPropetryFunctions(Context context, ElementBasicGraphPattern bgp, boolean doingMagicProperties, PropertyFunctionRegistry registry, List triples, List propertyFunctionTriples) {
        Iterator iter = bgp.getTriples().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Triple)) {
                log.warn((Object)("Don't recognize: [" + Utils.className(obj) + "]"));
                throw new ARQInternalErrorException("Not a triple pattern: " + obj.toString());
            }
            Triple t = (Triple)obj;
            triples.add(t);
            if (!doingMagicProperties || !PFuncOps.isMagicProperty(registry, t)) continue;
            propertyFunctionTriples.add(t);
        }
    }

    private static void makePropetryFunctions(Context context, PropertyFunctionRegistry registry, Map pfPlanElts, List triples, List propertyFunctionTriples) {
        Iterator iter = propertyFunctionTriples.iterator();
        while (iter.hasNext()) {
            Triple pf = (Triple)iter.next();
            PlanElement planElt = PFuncOps.magicProperty(context, registry, pf, triples);
            if (planElt == null) {
                log.warn((Object)"Lost a PlanElement for a property function");
                continue;
            }
            pfPlanElts.put(pf, planElt);
        }
    }

    private static void makePlanElements(Context context, List planBGPElements, Map pfPlanElts, List triples, List propertyFunctionTriples) {
        PlanBlockTriples pBlk = null;
        Iterator iter = triples.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (propertyFunctionTriples.contains(t)) {
                PlanElement planElt = (PlanElement)pfPlanElts.get(t);
                planBGPElements.add(planElt);
                pBlk = null;
                continue;
            }
            if (pBlk == null) {
                pBlk = new PlanBlockTriples(context);
                planBGPElements.add(pBlk);
            }
            pBlk.addTriple(t);
        }
    }
}

