/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.CompileException;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.iterator.QueryIter;
import com.hp.hpl.jena.query.engine1.plan.PlanElement0;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.extension.Extension;
import com.hp.hpl.jena.query.extension.ExtensionFactory;
import com.hp.hpl.jena.query.extension.ExtensionRegistry;
import com.hp.hpl.jena.query.util.Context;
import com.hp.hpl.jena.query.util.Utils;
import org.apache.commons.logging.LogFactory;

public class PlanExtension
extends PlanElement0 {
    ElementExtension element;

    public static PlanElement make(Context context, ElementExtension el) {
        return new PlanExtension(context, el);
    }

    private PlanExtension(Context context, ElementExtension el) {
        super(context);
        this.element = el;
    }

    public ElementExtension getElement() {
        return this.element;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        String uri = this.element.getURI();
        ExtensionFactory factory = ExtensionRegistry.get().get(uri);
        if (factory == null) {
            throw new CompileException("No extension for '" + uri + "'");
        }
        Extension ext = factory.create(uri);
        ext.build(uri, this.element.getArgs());
        if (input == null) {
            LogFactory.getLog(this.getClass()).fatal((Object)("Null input to " + Utils.classShortName(this.getClass())));
        }
        QueryIterator qIter = ext.exec(input, this.element.getArgs(), uri, execCxt);
        qIter = QueryIter.makeTracked(qIter, execCxt);
        return qIter;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform) {
        return transform.transform(this);
    }

    public PlanElement copy() {
        return PlanExtension.make(this.getContext(), this.element);
    }
}

