/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine1.plan;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.PlanVisitor;
import com.hp.hpl.jena.query.engine1.analyse.VarUsage;
import com.hp.hpl.jena.query.engine1.plan.PlanElementN;
import com.hp.hpl.jena.query.engine1.plan.PlanFilter;
import com.hp.hpl.jena.query.engine1.plan.PlanUtils;
import com.hp.hpl.jena.query.engine1.plan.Transform;
import com.hp.hpl.jena.query.util.Context;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanGroup
extends PlanElementN {
    private static Log log = LogFactory.getLog((Class)PlanGroup.class);
    public static boolean enableOrderWarnings = true;
    public static boolean removeGroupOfOne = true;
    private boolean canReorder = true;

    public static PlanElement make(Context context, List acc) {
        if (removeGroupOfOne && acc.size() == 1) {
            return (PlanElement)acc.get(0);
        }
        return new PlanGroup(context, acc, true);
    }

    public static PlanGroup make(Context context, List acc, boolean reorderable) {
        return new PlanGroup(context, acc, reorderable);
    }

    public boolean canReorder() {
        return this.canReorder;
    }

    protected PlanGroup(Context context, List subElts, boolean reorderable) {
        super(context, subElts);
        this.canReorder = reorderable;
        if (this.getContext().isTrue(ARQ.orderPlanning)) {
            this.planGroup();
        }
    }

    private void planGroup() {
        ArrayList<PlanElement> filters = new ArrayList<PlanElement>();
        Iterator iter = this.getSubElements().iterator();
        while (iter.hasNext()) {
            PlanElement elt = (PlanElement)iter.next();
            if (!(elt instanceof PlanFilter)) continue;
            filters.add(elt);
            iter.remove();
        }
        this.getSubElements().addAll(filters);
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        return PlanUtils.buildSerial(this, input, execCxt);
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }

    public PlanElement apply(Transform transform, List newSubElements) {
        return transform.transform(this, newSubElements);
    }

    public PlanElement copy(List newSubElements) {
        return PlanGroup.make(this.getContext(), newSubElements, false);
    }

    public void varsReport() {
        String vn;
        VarUsage varUsage = new VarUsage();
        varUsage.visit(this);
        System.out.println();
        System.out.print("Fixed:  ");
        Iterator iter = varUsage.getFixedUsageVars().iterator();
        while (iter.hasNext()) {
            vn = (String)iter.next();
            System.out.print(" " + vn);
        }
        System.out.println();
        System.out.print("Varying:");
        iter = varUsage.getOptionalUsageVars().iterator();
        while (iter.hasNext()) {
            vn = (String)iter.next();
            System.out.print(" " + vn);
        }
        System.out.println();
        System.out.print("Constrained:");
        iter = varUsage.getConstraintUsageVars().iterator();
        while (iter.hasNext()) {
            vn = (String)iter.next();
            System.out.print(" " + vn);
        }
        System.out.println();
    }
}

