/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2;

import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingImmutable;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecCtl;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterConcat;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterDistinct;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterLimitOffset;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterProject;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterSort;
import com.hp.hpl.jena.query.engine2.Evaluator;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.engine2.table.TableSimple;
import com.hp.hpl.jena.query.expr.Expr;
import java.util.ArrayList;
import java.util.List;

class EvaluatorSimple
implements Evaluator {
    private ExecutionContext context;
    boolean debug = false;

    EvaluatorSimple(ExecutionContext context) {
        this.context = context;
    }

    public ExecutionContext getExecContext() {
        return this.context;
    }

    public ExecCtl getExecCtl() {
        return this.context;
    }

    private Table joinWorker(Table tableLeft, Table tableRight, boolean leftJoin, Expr condition) {
        QueryIterator left = tableLeft.iterator(this.context);
        QueryIterConcat output = new QueryIterConcat(this.context);
        while (left.hasNext()) {
            Binding b = left.nextBinding();
            QueryIterator x = tableRight.matchRightLeft(b, leftJoin, condition, this.context);
            if (x == null) continue;
            output.add(x);
        }
        tableLeft.close();
        tableRight.close();
        return new TableSimple(output);
    }

    public Table join(Table tableLeft, Table tableRight) {
        if (this.debug) {
            System.out.println("Join");
            tableLeft.dump();
            tableRight.dump();
        }
        return this.joinWorker(tableLeft, tableRight, false, null);
    }

    public Table leftJoin(Table tableLeft, Table tableRight, Expr expr) {
        if (this.debug) {
            System.out.println("Left Join");
            tableLeft.dump();
            tableRight.dump();
            if (expr != null) {
                System.out.println(expr.toString());
            }
        }
        return this.joinWorker(tableLeft, tableRight, true, expr);
    }

    public Table restriction(Expr expression, Table table) {
        if (this.debug) {
            System.out.println("Restriction");
            System.out.println(expression.toString());
            table.dump();
        }
        QueryIterator iter = table.iterator(this.context);
        ArrayList<Binding> output = new ArrayList<Binding>();
        while (iter.hasNext()) {
            Binding b = iter.nextBinding();
            if (!expression.isSatisfied(b, this.context)) continue;
            output.add(b);
        }
        return new TableSimple(new QueryIterPlainWrapper(output.iterator(), this.context));
    }

    public Table union(Table tableLeft, Table tableRight) {
        if (this.debug) {
            System.out.println("Union");
            tableLeft.dump();
            tableRight.dump();
        }
        QueryIterConcat output = new QueryIterConcat(this.context);
        output.add(tableLeft.iterator(this.context));
        output.add(tableRight.iterator(this.context));
        return new TableSimple(output);
    }

    public Table order(Table table, List conditions) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterSort(qIter, conditions, this.getExecContext());
        return new TableSimple(qIter);
    }

    public Table project(Table table, List vars) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterProject(qIter, vars, this.getExecContext());
        return new TableSimple(qIter);
    }

    public Table distinct(Table table, List vars) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = BindingImmutable.create(vars, qIter, this.context);
        qIter = new QueryIterDistinct(qIter, this.getExecContext());
        return new TableSimple(qIter);
    }

    public Table slice(Table table, long start, long length) {
        QueryIterator qIter = table.iterator(this.getExecContext());
        qIter = new QueryIterLimitOffset(qIter, start, length, this.getExecContext());
        return new TableSimple(qIter);
    }
}

