/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.Plan;
import com.hp.hpl.jena.query.engine.QueryEngineBase;
import com.hp.hpl.jena.query.engine.QueryEngineFactory;
import com.hp.hpl.jena.query.engine.QueryEngineRegistry;
import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import com.hp.hpl.jena.query.engine2.AlgebraCompiler;
import com.hp.hpl.jena.query.engine2.OpSubstitute;
import com.hp.hpl.jena.query.engine2.Plan2;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.OpDistinct;
import com.hp.hpl.jena.query.engine2.op.OpOrder;
import com.hp.hpl.jena.query.engine2.op.OpProject;
import com.hp.hpl.jena.query.engine2.op.OpSlice;
import com.hp.hpl.jena.query.util.Context;
import org.apache.commons.logging.LogFactory;

public class QueryEngineRef
extends QueryEngineBase {
    public static boolean verbose = false;
    private static QueryEngineFactory factory = new QueryEngineFactory(){

        public boolean accept(Query query, Dataset dataset) {
            return true;
        }

        public QueryExecution create(Query query, Dataset dataset) {
            QueryEngineRef engine = new QueryEngineRef(query);
            engine.setDataset(dataset);
            return engine;
        }
    };
    private Op queryOp = null;
    private Op patternOp = null;

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }

    public QueryEngineRef(Query q) {
        this(q, null);
    }

    public QueryEngineRef(Query q, Context context) {
        super(q, context);
    }

    protected Plan queryToPlan(Query query, QueryEngineBase.Modifiers mods, Element pattern) {
        Op op = this.getOp();
        return new Plan2(op, this.getExecContext());
    }

    protected Op createPatternOp() {
        Op op = AlgebraCompiler.compile(this.query.getQueryPattern(), this.getContext());
        if (this.startBinding != null) {
            Binding b = QueryEngineUtils.asBinding(this.startBinding);
            op = OpSubstitute.substitute(b, op);
        }
        return op;
    }

    protected Op createOp() {
        Op op = this.getPatternOp();
        QueryEngineBase.Modifiers mods = new QueryEngineBase.Modifiers(this.query);
        if (mods.orderConditions != null) {
            op = new OpOrder(op, mods.orderConditions);
        }
        if (mods.projectVars != null && !this.query.isQueryResultStar()) {
            if (mods.projectVars.size() == 0 && this.query.isSelectType()) {
                LogFactory.getLog(this.getClass()).warn((Object)"No project variables");
            }
            if (mods.projectVars.size() > 0) {
                op = new OpProject(op, mods.projectVars);
            }
        }
        if (this.query.isDistinct() || this.getContext().isTrue(EngineConfig.autoDistinct)) {
            op = new OpDistinct(op, mods.projectVars);
        }
        if (this.query.hasLimit() || this.query.hasOffset()) {
            op = new OpSlice(op, mods.start, mods.length);
        }
        return op;
    }

    public Op getOp() {
        if (this.queryOp == null) {
            this.queryOp = this.createOp();
        }
        return this.queryOp;
    }

    public Op getPatternOp() {
        if (this.patternOp == null) {
            this.patternOp = this.createPatternOp();
        }
        return this.patternOp;
    }
}

