/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.op;

import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.plan.PlanBasicGraphPattern;
import com.hp.hpl.jena.query.engine2.Algebra;
import com.hp.hpl.jena.query.engine2.Evaluator;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.engine2.TableFactory;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.Op0;
import com.hp.hpl.jena.query.engine2.op.OpVisitor;
import com.hp.hpl.jena.query.engine2.op.Transform;
import java.util.List;

public class OpBGP
extends Op0 {
    private List pattern;
    private ElementBasicGraphPattern elBGP;

    public OpBGP(List pattern, ElementBasicGraphPattern el) {
        this.pattern = pattern;
        this.elBGP = el;
    }

    public Table eval(Evaluator evaluator) {
        ExecutionContext execCxt = evaluator.getExecContext();
        ElementBasicGraphPattern bgp = this.elBGP;
        if (this.elBGP == null) {
            bgp = new ElementBasicGraphPattern();
            bgp.getTriples().addAll(this.getPattern());
        }
        PlanElement planElt = PlanBasicGraphPattern.make(execCxt.getContext(), bgp);
        QueryIterator qIter = planElt.build(Algebra.makeRoot(execCxt), execCxt);
        return TableFactory.create(qIter);
    }

    public List getPattern() {
        return this.pattern;
    }

    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy() {
        return new OpBGP(this.pattern, this.elBGP);
    }
}

