/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.op;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine2.Evaluator;
import com.hp.hpl.jena.query.engine2.EvaluatorFactory;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.engine2.TableFactory;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.Op1;
import com.hp.hpl.jena.query.engine2.op.OpVisitor;
import com.hp.hpl.jena.query.engine2.op.Transform;
import com.hp.hpl.jena.query.engine2.table.TableEmpty;
import java.util.Iterator;

public class OpGraph
extends Op1 {
    Node node;

    public OpGraph(Node node, Op pattern) {
        super(pattern);
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public Table eval(Evaluator evaluator) {
        ExecutionContext execCxt = evaluator.getExecContext();
        if (!Var.isVar(this.node)) {
            Graph graph = execCxt.getDataset().getNamedGraph(this.node.getURI());
            if (graph == null) {
                return new TableEmpty();
            }
            ExecutionContext execCxt2 = new ExecutionContext(execCxt, graph);
            Evaluator e2 = EvaluatorFactory.create(execCxt2);
            return this.getSubOp().eval(e2);
        }
        Var gVar = Var.alloc(this.node);
        Table current = null;
        Iterator iter = execCxt.getDataset().listNames();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            Graph graph = execCxt.getDataset().getNamedGraph(uri);
            ExecutionContext execCxt2 = new ExecutionContext(execCxt, graph);
            Evaluator e2 = EvaluatorFactory.create(execCxt2);
            Table tableVarURI = TableFactory.create(gVar, Node.createURI((String)uri));
            Table patternTable = this.getSubOp().eval(e2);
            Table stepResult = evaluator.join(patternTable, tableVarURI);
            if (current == null) {
                current = stepResult;
                continue;
            }
            current = evaluator.union(current, stepResult);
        }
        if (current == null) {
            return new TableEmpty();
        }
        return current;
    }

    public Op apply(Transform transform, Op op) {
        return transform.transform(this, op);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op newOp) {
        return new OpGraph(this.node, newOp);
    }

    public Table eval_1(Table table, Evaluator evaluator) {
        throw new ARQInternalErrorException("OpGraph.eval_1 called");
    }
}

