/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.op;

import com.hp.hpl.jena.query.engine2.Evaluator;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.Op2;
import com.hp.hpl.jena.query.engine2.op.OpTable;
import com.hp.hpl.jena.query.engine2.op.OpVisitor;
import com.hp.hpl.jena.query.engine2.op.Transform;
import com.hp.hpl.jena.query.engine2.table.TableUnit;

public class OpJoin
extends Op2 {
    public static Op create(Op left, Op right) {
        if (left == null) {
            return right;
        }
        if (OpJoin.isJoinIdentify(left)) {
            OpJoin.closeTable((OpTable)left);
            return right;
        }
        if (OpJoin.isJoinIdentify(right)) {
            OpJoin.closeTable((OpTable)right);
            return left;
        }
        return new OpJoin(left, right);
    }

    private static boolean isJoinIdentify(Op op) {
        if (!(op instanceof OpTable)) {
            return false;
        }
        Table t = ((OpTable)op).getTable();
        return t instanceof TableUnit;
    }

    private static void closeTable(OpTable opTable) {
        opTable.getTable().close();
    }

    private OpJoin(Op left, Op right) {
        super(left, right);
    }

    public Table eval_2(Table tableLeft, Table tableRight, Evaluator evaluator) {
        return evaluator.join(tableLeft, tableRight);
    }

    public Op apply(Transform transform, Op left, Op right) {
        return transform.transform(this, left, right);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op newLeft, Op newRight) {
        return new OpJoin(newLeft, newRight);
    }
}

