/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.op;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.DatasetGraph;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding1;
import com.hp.hpl.jena.query.engine.BindingRoot;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.PlanElement;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterConcat;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterSingleton;
import com.hp.hpl.jena.query.engine1.plan.PlanBasicGraphPattern;
import com.hp.hpl.jena.query.engine2.Algebra;
import com.hp.hpl.jena.query.engine2.AlgebraCompilerQuad;
import com.hp.hpl.jena.query.engine2.Evaluator;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.engine2.TableFactory;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.Op0;
import com.hp.hpl.jena.query.engine2.op.OpVisitor;
import com.hp.hpl.jena.query.engine2.op.Quad;
import com.hp.hpl.jena.query.engine2.op.Transform;
import com.hp.hpl.jena.query.engine2.table.TableEmpty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OpQuadPattern
extends Op0 {
    Node graphNode;
    List triples;
    List quads = null;

    public OpQuadPattern(Node quadNode, List triples) {
        this.graphNode = quadNode;
        this.triples = triples;
    }

    public List getQuads() {
        if (this.quads == null) {
            this.quads = new ArrayList();
            Iterator iter = this.triples.iterator();
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                this.quads.add(new Quad(this.graphNode, t));
            }
        }
        return this.quads;
    }

    public Node getGraphNode() {
        return this.graphNode;
    }

    public Table eval(Evaluator evaluator) {
        if (this.getQuads().size() == 0) {
            return TableFactory.createUnit();
        }
        ExecutionContext cxt = evaluator.getExecContext();
        DatasetGraph ds = cxt.getDataset();
        ElementBasicGraphPattern bgp = new ElementBasicGraphPattern();
        bgp.getTriples().addAll(this.triples);
        if (!this.graphNode.isVariable()) {
            if (!this.graphNode.isURI()) {
                throw new ARQInternalErrorException("Not a URI or variable: " + this.graphNode);
            }
            Graph g = null;
            g = this.graphNode.equals((Object)AlgebraCompilerQuad.defaultGraph) ? ds.getDefaultGraph() : ds.getNamedGraph(this.graphNode.getURI());
            if (g == null) {
                return new TableEmpty();
            }
            ExecutionContext cxt2 = new ExecutionContext(cxt, g);
            PlanElement planElt = PlanBasicGraphPattern.make(cxt2.getContext(), bgp);
            return TableFactory.create(planElt.build(Algebra.makeRoot(cxt2), cxt2));
        }
        Var gVar = Var.alloc(this.graphNode);
        QueryIterConcat concat = new QueryIterConcat(cxt);
        Iterator graphURIs = cxt.getDataset().listNames();
        while (graphURIs.hasNext()) {
            String uri = (String)graphURIs.next();
            Graph g = cxt.getDataset().getNamedGraph(uri);
            Binding1 b = new Binding1(BindingRoot.create(), gVar, Node.createURI((String)uri));
            QueryIterSingleton qIter1 = new QueryIterSingleton(b, cxt);
            ExecutionContext cxt2 = new ExecutionContext(cxt, g);
            PlanElement planElt = PlanBasicGraphPattern.make(cxt2.getContext(), bgp);
            QueryIterator qIter = planElt.build(qIter1, cxt2);
            concat.add(qIter);
        }
        return TableFactory.create(concat);
    }

    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy() {
        return new OpQuadPattern(this.graphNode, this.triples);
    }
}

