/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.op;

import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.plan.PlanElementExternalBase;
import com.hp.hpl.jena.query.engine2.EvaluatorFactory;
import com.hp.hpl.jena.query.engine2.Table;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.OpWriter;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.shared.PrefixMapping;

public class PlanElementOp
extends PlanElementExternalBase {
    private Op op;

    private PlanElementOp(Op op) {
        this.op = op;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        Op thisOp = this.op;
        if (!input.hasNext()) {
            System.err.println("Warning: input is empty");
        } else {
            input.nextBinding();
            if (input.hasNext()) {
                System.err.println("Warning: input has 2+ elements");
            }
        }
        input.close();
        Table t = thisOp.eval(EvaluatorFactory.create(execCxt));
        QueryIterator qIter = t.iterator(execCxt);
        return qIter;
    }

    public String toString(PrefixMapping pMap) {
        return FmtUtils.toString(this.op, pMap);
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.print("[");
        out.println("PlanElementOp");
        out.incIndent();
        OpWriter.out(out, this.op, sCxt);
        out.decIndent();
        out.print("]");
    }
}

