/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.engine2.op;

import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.engine2.op.Op;
import com.hp.hpl.jena.query.engine2.op.Op0;
import com.hp.hpl.jena.query.engine2.op.Op1;
import com.hp.hpl.jena.query.engine2.op.Op2;
import com.hp.hpl.jena.query.engine2.op.OpBGP;
import com.hp.hpl.jena.query.engine2.op.OpDatasetNames;
import com.hp.hpl.jena.query.engine2.op.OpDistinct;
import com.hp.hpl.jena.query.engine2.op.OpExt;
import com.hp.hpl.jena.query.engine2.op.OpFilter;
import com.hp.hpl.jena.query.engine2.op.OpGraph;
import com.hp.hpl.jena.query.engine2.op.OpJoin;
import com.hp.hpl.jena.query.engine2.op.OpLeftJoin;
import com.hp.hpl.jena.query.engine2.op.OpOrder;
import com.hp.hpl.jena.query.engine2.op.OpPlanElement;
import com.hp.hpl.jena.query.engine2.op.OpProject;
import com.hp.hpl.jena.query.engine2.op.OpQuadPattern;
import com.hp.hpl.jena.query.engine2.op.OpSlice;
import com.hp.hpl.jena.query.engine2.op.OpTable;
import com.hp.hpl.jena.query.engine2.op.OpUnion;
import com.hp.hpl.jena.query.engine2.op.OpVisitor;
import com.hp.hpl.jena.query.engine2.op.Transform;
import com.hp.hpl.jena.query.util.Utils;
import java.util.Stack;
import org.apache.commons.logging.LogFactory;

public class Transformer {
    static boolean noDupIfSame = true;
    static /* synthetic */ Class class$com$hp$hpl$jena$query$engine2$op$Transformer$TransformApply;

    public static Op transform(Transform tranform, Op op) {
        if (op == null) {
            LogFactory.getLog((Class)Transformer.class).warn((Object)"Attempt to transform a null Op  - ignored");
            return op;
        }
        TransformApply v = new TransformApply(tranform);
        op.visit(v);
        return v.result();
    }

    private Transformer() {
    }

    static class TransformApply
    implements OpVisitor {
        Transform transform = null;
        Stack stack = new Stack();

        private Op pop() {
            return (Op)this.stack.pop();
        }

        private void push(Op op) {
            this.stack.push(op);
        }

        public TransformApply(Transform transform) {
            this.transform = transform;
        }

        public Op result() {
            if (this.stack.size() != 1) {
                LogFactory.getLog((Class)(class$com$hp$hpl$jena$query$engine2$op$Transformer$TransformApply == null ? (class$com$hp$hpl$jena$query$engine2$op$Transformer$TransformApply = Transformer.class$("com.hp.hpl.jena.query.engine2.op.Transformer$TransformApply")) : class$com$hp$hpl$jena$query$engine2$op$Transformer$TransformApply)).warn((Object)"Stack is not aligned");
            }
            return this.pop();
        }

        private void visit0(Op0 op) {
            this.push(op.apply(this.transform));
        }

        private void visit1(Op1 op) {
            op.getSubOp().visit(this);
            Op subOp = this.pop();
            this.push(op.apply(this.transform, subOp));
        }

        private void visit2(Op2 op) {
            op.getLeft().visit(this);
            Op left = this.pop();
            op.getRight().visit(this);
            Op right = this.pop();
            Op opX = op.apply(this.transform, left, right);
            this.push(opX);
        }

        public void visit(OpTable opTable) {
            this.visit0(opTable);
        }

        public void visit(OpQuadPattern quadPattern) {
            this.visit0(quadPattern);
        }

        public void visit(OpDatasetNames dsNames) {
            this.visit0(dsNames);
        }

        public void visit(OpBGP op) {
            this.visit0(op);
        }

        public void visit(OpJoin opJoin) {
            this.visit2(opJoin);
        }

        public void visit(OpLeftJoin opLeftJoin) {
            this.visit2(opLeftJoin);
        }

        public void visit(OpUnion opUnion) {
            this.visit2(opUnion);
        }

        public void visit(OpFilter opFilter) {
            this.visit1(opFilter);
        }

        public void visit(OpGraph opGraph) {
            this.visit1(opGraph);
        }

        public void visit(OpPlanElement element) {
            throw new ARQInternalErrorException("Can't transform a " + Utils.className(element));
        }

        public void visit(OpExt opExt) {
            throw new ARQInternalErrorException("Can't transform a " + Utils.className(opExt));
        }

        public void visit(OpOrder opOrder) {
            throw new ARQInternalErrorException("Can't transform a " + Utils.className(opOrder));
        }

        public void visit(OpProject opProject) {
            throw new ARQInternalErrorException("Can't transform a " + Utils.className(opProject));
        }

        public void visit(OpDistinct opDistinct) {
            throw new ARQInternalErrorException("Can't transform a " + Utils.className(opDistinct));
        }

        public void visit(OpSlice opSlice) {
            throw new ARQInternalErrorException("Can't tranform a " + Utils.className(opSlice));
        }
    }
}

