/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprFunction2;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;

public class E_LogicalAnd
extends ExprFunction2 {
    private static final String printName = "and";
    private static final String symbol = "&&";

    public E_LogicalAnd(Expr left, Expr right) {
        super(left, right, printName, symbol);
    }

    public NodeValue evalSpecial(Binding binding, ExecutionContext execCxt) {
        ExprEvalException error = null;
        try {
            NodeValue x = this.getArg1().eval(binding, execCxt);
            if (!Functions.booleanEffectiveValue(x)) {
                return NodeValue.FALSE;
            }
        }
        catch (ExprEvalException eee) {
            error = eee;
        }
        try {
            NodeValue y = this.getArg2().eval(binding, execCxt);
            if (!Functions.booleanEffectiveValue(y)) {
                return NodeValue.FALSE;
            }
            if (error != null) {
                throw error;
            }
            return NodeValue.TRUE;
        }
        catch (ExprEvalException eee) {
            if (error != null) {
                throw error;
            }
            throw eee;
        }
    }

    public NodeValue eval(NodeValue x, NodeValue y) {
        throw new ARQInternalErrorException("Can't do that to " + this.getClass());
    }

    public Expr copy(Expr e1, Expr e2) {
        return new E_LogicalAnd(e1, e2);
    }
}

