/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.function;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.function.FunctionBase1;

class Instance
extends FunctionBase1 {
    XSDDatatype castType;

    Instance(XSDDatatype dt) {
        this.castType = dt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeValue exec(NodeValue v) {
        String s = null;
        Node n = v.asNode();
        if (n.isBlank()) {
            throw new ExprEvalException("CastXSD: Can't cast blank nodes: " + v);
        }
        if (n.isURI()) {
            if (!this.castType.equals(XSDDatatype.XSDstring)) throw new ExprEvalException("CastXSD: Can't cast node: " + v + " to " + this.castType.getURI());
            s = n.getURI();
        } else {
            if (!n.isLiteral()) throw new ExprEvalException("CastXSD: Can't cast node: " + v + "(not a literal, not URI to string)");
            s = n.getLiteralLexicalForm();
        }
        if (s == null && v.isString()) {
            s = v.getString();
        }
        if (s == null) {
            throw new ExprEvalException("CastXSD: Can't cast: " + v + "(has no string appearance)");
        }
        if (this.castType.isValid(s)) return NodeValue.makeNode(s, this.castType);
        throw new ExprEvalException("CastXSD: Not a valid literal form: " + s);
    }
}

