/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.query.lang.ParserARQ;
import com.hp.hpl.jena.query.lang.ParserN3QL;
import com.hp.hpl.jena.query.lang.ParserPrefix;
import com.hp.hpl.jena.query.lang.ParserRDQL;
import com.hp.hpl.jena.query.lang.ParserSPARQL;
import com.hp.hpl.jena.query.lang.ParserSPARQLdev;
import com.hp.hpl.jena.query.lang.ParserXML;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Parser {
    static Log log = LogFactory.getLog((Class)Parser.class);

    public abstract Query parse(Query var1, String var2) throws QueryParseException;

    public static boolean canParse(Syntax syntaxURI) {
        Parser p = Parser.createParser(syntaxURI);
        return p != null;
    }

    public static Parser createParser(Syntax syntaxURI) {
        if (syntaxURI.equals(Syntax.syntaxSPARQL)) {
            return new ParserSPARQL();
        }
        if (syntaxURI.equals(Syntax.syntaxSPARQLdev)) {
            return new ParserSPARQLdev();
        }
        if (syntaxURI.equals(Syntax.syntaxPrefix)) {
            return new ParserPrefix();
        }
        if (syntaxURI.equals(Syntax.syntaxSPARQL_X)) {
            return new ParserXML();
        }
        if (syntaxURI.equals(Syntax.syntaxARQ)) {
            return new ParserARQ();
        }
        if (syntaxURI.equals(Syntax.syntaxRDQL)) {
            return new ParserRDQL();
        }
        if (syntaxURI.equals(Syntax.syntaxN3QL)) {
            return new ParserN3QL();
        }
        return null;
    }

    protected void validateParsedQuery(Query query) {
    }
}

