/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.ARQNotImplemented;
import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;

public abstract class IndexBuilderLiteral
extends IndexBuilderModel {
    private Set seen = new HashSet();

    public IndexBuilderLiteral() {
    }

    public IndexBuilderLiteral(IndexWriter existingWriter) {
        super(existingWriter);
    }

    public IndexBuilderLiteral(File fileDir) {
        super(fileDir);
    }

    public IndexBuilderLiteral(String fileDir) {
        super(fileDir);
    }

    protected abstract boolean indexThisLiteral(Literal var1);

    protected abstract boolean indexThisStatement(Statement var1);

    public void unindexStatement(Statement s) {
        throw new ARQNotImplemented("unindexStatement");
    }

    public void indexStatement(Statement s) {
        if (!this.indexThisStatement(s)) {
            return;
        }
        try {
            Node node;
            if (s.getObject().isLiteral() && !this.seen.contains(node = s.getObject().asNode()) && this.indexThisLiteral(s.getLiteral())) {
                Document doc = new Document();
                LARQ.store(doc, node);
                LARQ.index(doc, node);
                this.getIndexWriter().addDocument(doc);
                this.seen.add(node);
            }
        }
        catch (Exception e2) {
            throw new ARQLuceneException("indexStatement", e2);
        }
    }

    public void closeForWriting() {
        super.closeForWriting();
        this.seen = null;
    }
}

