/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.Binding1;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterSingleton;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.pfunction.PFuncSimple;
import com.hp.hpl.jena.query.pfunction.PropFuncArg;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class LuceneSearch
extends PFuncSimple {
    protected abstract IndexLARQ getIndex(ExecutionContext var1);

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        super.build(argSubject, predicate, argObject, execCxt);
        Node obj = argObject.getArg();
        if (this.getIndex(execCxt) == null) {
            throw new QueryBuildException("Index not found");
        }
        if (!obj.isLiteral()) {
            throw new QueryBuildException("Not a string: " + argObject.getArg());
        }
        if (obj.getLiteralDatatypeURI() != null) {
            throw new QueryBuildException("Not a plain string: " + argObject.getArg());
        }
        if (obj.getLiteralLanguage() != null && !obj.getLiteralLanguage().equals("")) {
            throw new QueryBuildException("Not a plain string (has lang tag): " + argObject.getArg());
        }
    }

    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, Node searchString, ExecutionContext execCxt) {
        Object queryString = null;
        if (!searchString.isLiteral()) {
            System.err.println("Not a literal: " + subject);
            return new QueryIterNullIterator(execCxt);
        }
        String qs = this.asString(searchString);
        if (qs == null) {
            System.err.println("Not a string: " + subject);
            return new QueryIterNullIterator(execCxt);
        }
        if (subject.isVariable()) {
            return this.varSubject(binding, subject, qs, execCxt);
        }
        return this.boundSubject(binding, subject, qs, execCxt);
    }

    public QueryIterator varSubject(Binding binding, Node subject, String searchString, ExecutionContext execCxt) {
        Iterator iter = this.getIndex(execCxt).search(searchString);
        ArrayList<Binding1> results = new ArrayList<Binding1>();
        while (iter.hasNext()) {
            Node x = (Node)iter.next();
            results.add(new Binding1(binding, Var.alloc(subject), x));
        }
        return new QueryIterPlainWrapper(results.iterator(), execCxt);
    }

    public QueryIterator boundSubject(Binding binding, Node subject, String searchString, ExecutionContext execCxt) {
        if (this.getIndex(execCxt).contains(subject, searchString)) {
            return new QueryIterSingleton(binding, execCxt);
        }
        return new QueryIterNullIterator(execCxt);
    }

    private String asString(Node node) {
        if (node.getLiteralDatatype() != null && !node.getLiteralDatatype().equals("") && !node.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            return null;
        }
        return node.getLiteralLexicalForm();
    }
}

