/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.pfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.PrintSerializableBase;
import com.hp.hpl.jena.query.util.PrintUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PropFuncArg
extends PrintSerializableBase {
    private List argList = null;
    private Node arg = null;

    public PropFuncArg(List argList, Node arg) {
        if (argList == null) {
            this.arg = arg;
            return;
        }
        this.argList = argList;
    }

    public PropFuncArg(List argList) {
        this.argList = argList;
    }

    public PropFuncArg(Node arg) {
        this.arg = arg;
    }

    public Node getArg() {
        return this.arg;
    }

    public List getArgList() {
        return this.argList;
    }

    public Node getArg(int index) {
        if (this.argList == null) {
            return null;
        }
        return (Node)this.argList.get(index);
    }

    public boolean isList() {
        return this.argList != null;
    }

    public void output(IndentedWriter out, final SerializationContext sCxt) {
        if (this.argList == null && this.arg == null) {
            out.print("<<null>>");
        }
        if (this.argList != null) {
            out.print("(");
            PrintUtils.printList(out, this.argList, " ", new PrintUtils.Fmt(){

                public String fmt(Object thing) {
                    return FmtUtils.stringForNode((Node)thing, sCxt);
                }
            });
            out.print(")");
        }
        if (this.arg != null) {
            out.print(FmtUtils.stringForNode(this.arg));
        }
    }

    public PropFuncArg evalIfExists(Binding binding) {
        if (!this.isList()) {
            return new PropFuncArg(PropFuncArg.evalIfExistsOneArg(binding, this.arg));
        }
        ArrayList<Node> newArgList = new ArrayList<Node>();
        Iterator iter = this.argList.iterator();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            newArgList.add(PropFuncArg.evalIfExistsOneArg(binding, n));
        }
        return new PropFuncArg(newArgList);
    }

    private static Node evalIfExistsOneArg(Binding binding, Node n) {
        if (!n.isVariable()) {
            return n;
        }
        Node r = binding.get(Var.alloc(n));
        return r != null ? r : n;
    }
}

