/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.pfunction;

import com.hp.hpl.jena.query.engine1.EngineConfig;
import com.hp.hpl.jena.query.pfunction.PropertyFunction;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionFactoryAuto;
import com.hp.hpl.jena.query.pfunction.library.container;
import com.hp.hpl.jena.query.pfunction.library.listIndex;
import com.hp.hpl.jena.query.pfunction.library.listLength;
import com.hp.hpl.jena.query.pfunction.library.listMember;
import com.hp.hpl.jena.query.pfunction.library.splitIRI;
import com.hp.hpl.jena.query.util.Loader;
import com.hp.hpl.jena.query.vocabulary.ListPFunction;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyFunctionRegistry {
    static Log log = LogFactory.getLog((Class)PropertyFunctionRegistry.class);
    static PropertyFunctionRegistry globalRegistry = null;
    Map registry = new HashMap();
    Set attemptedLoads = new HashSet();

    public static synchronized PropertyFunctionRegistry standardRegistry() {
        PropertyFunctionRegistry reg = new PropertyFunctionRegistry();
        reg.loadStdDefs();
        return reg;
    }

    public static synchronized PropertyFunctionRegistry get() {
        PropertyFunctionRegistry reg = (PropertyFunctionRegistry)EngineConfig.getContext().get(EngineConfig.registryPropertyFunctions);
        if (reg == null) {
            reg = PropertyFunctionRegistry.standardRegistry();
            EngineConfig.getContext().set(EngineConfig.registryPropertyFunctions, reg);
        }
        return reg;
    }

    public void put(String uri, PropertyFunctionFactory factory) {
        this.registry.put(uri, factory);
    }

    public void put(String uri, Class extClass) {
        if (!PropertyFunction.class.isAssignableFrom(extClass)) {
            log.warn((Object)("Class " + extClass.getName() + " is not an PropertyFunction"));
            return;
        }
        this.registry.put(uri, new PropertyFunctionFactoryAuto(extClass));
    }

    public boolean manages(String uri) {
        if (this.registry.containsKey(uri)) {
            return true;
        }
        return uri.startsWith("java:");
    }

    public PropertyFunctionFactory get(String uri) {
        PropertyFunctionFactory ext = (PropertyFunctionFactory)this.registry.get(uri);
        if (ext != null) {
            return ext;
        }
        if (!uri.startsWith("java:")) {
            return null;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class extClass = Loader.loadClass(uri, PropertyFunction.class);
        if (extClass == null) {
            return null;
        }
        this.put(uri, extClass);
        this.attemptedLoads.add(uri);
        return (PropertyFunctionFactory)this.registry.get(uri);
    }

    public boolean isRegistered(String uri) {
        return this.registry.containsKey(uri);
    }

    public PropertyFunctionFactory remove(String uri) {
        return (PropertyFunctionFactory)this.registry.remove(uri);
    }

    public Iterator keys() {
        return this.registry.keySet().iterator();
    }

    private void loadStdDefs() {
        this.put(ListPFunction.member.getURI(), listMember.class);
        this.put(ListPFunction.index.getURI(), listIndex.class);
        this.put(ListPFunction.length.getURI(), listLength.class);
        this.put(ListPFunction.listMember.getURI(), listMember.class);
        this.put(ListPFunction.listIndex.getURI(), listIndex.class);
        this.put(ListPFunction.listLength.getURI(), listLength.class);
        this.put(RDFS.member.getURI(), container.class);
        this.put("http://jena.hpl.hp.com/ARQ#splitIRI", splitIRI.class);
    }
}

