/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.pfunction.library;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.pfunction.PFLib;
import com.hp.hpl.jena.query.pfunction.library.ListBase1;
import com.hp.hpl.jena.query.util.GNode;
import com.hp.hpl.jena.query.util.GraphList;
import com.hp.hpl.jena.query.util.NodeUtils;

public class listLength
extends ListBase1 {
    public QueryIterator execOneList(Binding binding, Node listNode, Node predicate, Node length, ExecutionContext execCxt) {
        Graph graph = execCxt.getActiveGraph();
        if (Var.isVar(listNode)) {
            throw new ARQInternalErrorException("listLength: Subject is a variable");
        }
        if (Var.isVar(length)) {
            return this.length(binding, graph, listNode, Var.alloc(length), execCxt);
        }
        return this.verify(binding, graph, listNode, length, execCxt);
    }

    private QueryIterator length(Binding binding, Graph graph, Node listNode, Var varLength, ExecutionContext execCxt) {
        int x = GraphList.length(new GNode(graph, listNode));
        if (x < 0) {
            return PFLib.noResults(execCxt);
        }
        Node n = NodeUtils.intToNode(x);
        return PFLib.oneResult(binding, varLength, n, execCxt);
    }

    private QueryIterator verify(Binding binding, Graph graph, Node listNode, Node length, ExecutionContext execCxt) {
        int len;
        int x = GraphList.length(new GNode(graph, listNode));
        if (x == (len = NodeUtils.nodeToInt(length))) {
            return PFLib.result(binding, execCxt);
        }
        return PFLib.noResults(execCxt);
    }
}

