/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingComparator;
import com.hp.hpl.jena.query.engine.BindingMap;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class SortedResultSet
implements ResultSet {
    ResultSet resultSet;

    public SortedResultSet(ResultSet rs, List conditions) {
        this(rs, new BindingComparator(conditions));
    }

    private SortedResultSet(ResultSet rs, Comparator comparator) {
        TreeSet<Binding> sorted = new TreeSet<Binding>(comparator);
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            Binding b = null;
            b = qs instanceof ResultBinding ? ((ResultBinding)qs).getBinding() : this.copyToBinding(qs);
            sorted.add(b);
        }
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(sorted.iterator());
        this.resultSet = new ResultSetStream(rs.getResultVars(), null, qIter);
    }

    public boolean hasNext() {
        return this.resultSet.hasNext();
    }

    public Object next() {
        return this.resultSet.next();
    }

    public QuerySolution nextSolution() {
        return this.resultSet.nextSolution();
    }

    public int getRowNumber() {
        return this.resultSet.getRowNumber();
    }

    public List getResultVars() {
        return this.resultSet.getResultVars();
    }

    public boolean isOrdered() {
        return true;
    }

    public boolean isDistinct() {
        return this.resultSet.isDistinct();
    }

    public void remove() {
        throw new UnsupportedOperationException(SortedResultSet.class.getName() + ".remove");
    }

    private Binding copyToBinding(QuerySolution qs) {
        BindingMap b = new BindingMap();
        Iterator iter = qs.varNames();
        while (iter.hasNext()) {
            String varName = (String)iter.next();
            RDFNode rn = qs.get(varName);
            b.add(Var.alloc(varName), rn.asNode());
        }
        return b;
    }
}

