/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.BindingMap;
import com.hp.hpl.jena.query.engine.ResultSetStream;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.query.resultset.ResultSetException;
import com.hp.hpl.jena.query.resultset.SPARQLResult;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.GraphUtils;
import com.hp.hpl.jena.query.util.LabelToNodeMap;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class XMLInputSAX
extends SPARQLResult {
    static Log log = LogFactory.getLog((Class)XMLInputSAX.class);

    public XMLInputSAX(InputStream in, Model model) {
        if (model == null) {
            model = GraphUtils.makeJenaDefaultModel();
        }
        try {
            InputSource input = new InputSource(in);
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            ResultSetXMLHandler2 handler = new ResultSetXMLHandler2();
            xr.setContentHandler(handler);
            xr.parse(input);
            if (handler.isBooleanResult) {
                this.set(handler.askResult);
                return;
            }
            ResultSetStream rss = new ResultSetStream(handler.variables, model, new QueryIterPlainWrapper(handler.results.iterator()));
            rss.setDistinct(handler.distinct);
            rss.setDistinct(handler.ordered);
            this.set(rss);
        }
        catch (SAXException ex) {
            throw new ResultSetException("Problems parsing file (SAXException)", ex);
        }
        catch (IOException ex) {
            throw new ResultSetException("Problems parsing file (IOException)", ex);
        }
    }

    static class ResultSetXMLHandler2
    implements ContentHandler {
        static final String namespace = "http://www.w3.org/2005/sparql-results#";
        static final String variableElt = "variable";
        static final String resultElt = "result";
        boolean ordered = false;
        boolean distinct = false;
        boolean isBooleanResult = false;
        boolean askResult = false;
        int rowCount = 0;
        LabelToNodeMap bNodes = new LabelToNodeMap(false);
        boolean accumulate = false;
        StringBuffer buff = new StringBuffer();
        List variables = new ArrayList();
        List results = new ArrayList();
        Binding binding = null;
        String varName;
        String datatype = null;
        String langTag = null;
        String rdfPrefix = "rdf";

        ResultSetXMLHandler2() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (uri.equals(RDF.getURI())) {
                this.rdfPrefix = prefix;
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String ns, String localName, String qName, Attributes attrs) throws SAXException {
            if (!ns.equals(namespace)) {
                log.info((Object)(qName + ": Different namespace: " + ns));
                return;
            }
            if (localName.equals(variableElt)) {
                if (attrs.getValue("name") != null) {
                    String name = attrs.getValue("name");
                    this.variables.add(name);
                }
                return;
            }
            if (localName.equals("results")) {
                String aOrdered = attrs.getValue("ordered");
                String aDistinct = attrs.getValue("distinct");
                if (aOrdered != null && aOrdered.equals("true")) {
                    this.ordered = true;
                }
                if (aDistinct != null && aDistinct.equals("true")) {
                    this.distinct = true;
                }
                return;
            }
            if (localName.equals("boolean")) {
                this.isBooleanResult = true;
            }
            if (localName.equals(resultElt)) {
                this.binding = new BindingMap();
                return;
            }
            if (localName.equals("binding")) {
                this.varName = attrs.getValue("name");
                return;
            }
            if (localName.equals("uri")) {
                this.startElementURI(ns, localName, qName, attrs);
                return;
            }
            if (localName.equals("literal")) {
                this.startElementLiteral(ns, localName, qName, attrs);
                return;
            }
            if (localName.equals("bnode")) {
                this.startElementBNode(ns, localName, qName, attrs);
                return;
            }
            if (localName.equals("unbound")) {
                return;
            }
        }

        public void endElement(String ns, String localName, String qName) throws SAXException {
            if (!ns.equals(namespace)) {
                return;
            }
            if (localName.equals("results")) {
                return;
            }
            if (localName.equals("boolean")) {
                this.endElementBoolean();
                return;
            }
            if (localName.equals(resultElt)) {
                this.varName = null;
                this.datatype = null;
                this.langTag = null;
                this.results.add(this.binding);
                this.binding = null;
                return;
            }
            if (localName.equals("binding")) {
                this.varName = null;
                return;
            }
            if (localName.equals("uri")) {
                this.endElementURI(ns, localName, qName);
                return;
            }
            if (localName.equals("literal")) {
                this.endElementLiteral(ns, localName, qName);
                return;
            }
            if (localName.equals("bnode")) {
                this.endElementBNode(ns, localName, qName);
                return;
            }
            if (localName.equals("unbound")) {
                return;
            }
        }

        private boolean checkVarName(String cxtMsg) {
            if (cxtMsg == null) {
                cxtMsg = "";
            }
            if (this.varName == null) {
                log.warn((Object)("No variable name in scope: " + cxtMsg));
                return false;
            }
            if (!this.variables.contains(this.varName)) {
                log.warn((Object)("Variable name '" + this.varName + "'not declared: " + cxtMsg));
                return false;
            }
            return true;
        }

        private void startElementURI(String ns, String localName, String name, Attributes attrs) {
            this.startAccumulate();
        }

        private void endElementURI(String ns, String localName, String name) {
            this.endAccumulate();
            String uri = this.buff.toString();
            Node n = Node.createURI((String)uri);
            if (this.checkVarName("URI: " + uri)) {
                this.binding.add(Var.alloc(this.varName), n);
            }
        }

        private void startElementLiteral(String ns, String localName, String name, Attributes attrs) {
            if (attrs.getValue("datatype") != null) {
                this.datatype = attrs.getValue("datatype");
            }
            if (attrs.getValue("xml:lang") != null) {
                this.langTag = attrs.getValue("xml:lang");
            }
            this.startAccumulate();
        }

        private void endElementLiteral(String ns, String localName, String name) {
            this.endAccumulate();
            String lexicalForm = this.buff.toString();
            RDFDatatype dType = null;
            if (this.datatype != null) {
                dType = TypeMapper.getInstance().getSafeTypeByName(this.datatype);
            }
            Node n = Node.createLiteral((String)lexicalForm.toString(), (String)this.langTag, (RDFDatatype)dType);
            if (this.checkVarName("Literal: " + FmtUtils.stringForNode(n))) {
                this.binding.add(Var.alloc(this.varName), n);
            }
            this.datatype = null;
            this.langTag = null;
            this.varName = null;
        }

        private void endElementBoolean() {
            this.endAccumulate();
            String result = this.buff.toString();
            if (result.equals("true")) {
                this.askResult = true;
            }
        }

        private void startElementBNode(String ns, String localName, String name, Attributes attrs) {
            this.startAccumulate();
        }

        private void endElementBNode(String ns, String localName, String name) {
            this.endAccumulate();
            String bnodeId = this.buff.toString();
            Node node = this.bNodes.asNode(bnodeId);
            if (this.checkVarName("BNode: " + bnodeId)) {
                this.binding.add(Var.alloc(this.varName), node);
            }
        }

        private void startAccumulate() {
            this.buff.setLength(0);
            this.accumulate = true;
        }

        private void endAccumulate() {
            this.accumulate = false;
        }

        public void characters(char[] chars, int start, int finish) throws SAXException {
            if (this.accumulate) {
                if (this.buff == null) {
                    this.buff = new StringBuffer();
                }
                this.buff.append(chars, start, finish);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

