/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasicGraphPattern;
import com.hp.hpl.jena.query.core.ElementDataset;
import com.hp.hpl.jena.query.core.ElementExtension;
import com.hp.hpl.jena.query.core.ElementFilter;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprARQ;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FormatterARQ
extends FormatterBase
implements FormatterElement {
    public static boolean PATTERN_MARKERS = false;
    public static boolean GROUP_SEP_DOT = false;
    public static boolean GROUP_FIRST_ON_SAME_LINE = false;
    public static boolean PRETTY_PRINT = true;
    public static boolean UNION_MARKERS = false;
    public static boolean GROUP_UNNEST_ONE = false;
    public static boolean GRAPH_FIXED_INDENT = true;
    public static boolean UNSAID_FIXED_INDENT = true;
    public static int TRIPLES_SUBJECT_COLUMN = 8;
    public static int TRIPLES_SUBJECT_LONG = 12;
    public static int TRIPLES_PROPERTY_COLUMN = 20;
    public static int TRIPLES_COLUMN_GAP = 2;
    int subjectWidth = -1;
    int predicateWidth = -1;

    public FormatterARQ(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Element el) {
        FormatterARQ fmt = new FormatterARQ(out, cxt);
        fmt.startVisit();
        el.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Element el) {
        SerializationContext cxt = new SerializationContext(null, null, null);
        IndentedLineBuffer b = new IndentedLineBuffer();
        FormatterARQ.format(b.getIndentedWriter(), cxt, el);
        return b.toString();
    }

    public boolean topMustBeGroup() {
        return true;
    }

    public void visit(ElementBasicGraphPattern el) {
        if (el.isEmpty()) {
            this.out.println("# Empty BGP");
            return;
        }
        this.formatTriples(el.getTriples());
    }

    public void visit(ElementDataset el) {
        if (el.getPatternElement() != null) {
            this.visitAsGroup(el.getPatternElement());
        }
    }

    public void visit(ElementFilter el) {
        this.out.print("FILTER ");
        Expr expr = el.getExpr();
        FmtExprARQ v = new FmtExprARQ(this.out, this.context);
        boolean addParens = false;
        if (expr.isVariable()) {
            addParens = true;
        }
        if (expr.isConstant()) {
            addParens = true;
        }
        if (addParens) {
            this.out.print("( ");
        }
        expr.visit(v);
        if (addParens) {
            this.out.print(" )");
        }
    }

    public void visit(ElementUnion el) {
        if (el.getElements().size() == 1) {
            Element e2 = (Element)el.getElements().get(0);
            this.visitAsGroup(e2);
            return;
        }
        if (UNION_MARKERS) {
            this.out.print("{");
            this.out.newline();
            this.out.pad();
        }
        this.out.incIndent(2);
        boolean first = true;
        ListIterator iter = el.getElements().listIterator();
        while (iter.hasNext()) {
            if (!first) {
                this.out.decIndent(2);
                this.out.newline();
                this.out.print("UNION");
                this.out.newline();
                this.out.incIndent(2);
            }
            Element subElement = (Element)iter.next();
            this.visitAsGroup(subElement);
            first = false;
        }
        this.out.decIndent(2);
        if (UNION_MARKERS) {
            this.out.newline();
            this.out.print("}");
        }
    }

    public void visit(ElementGroup el) {
        if (GROUP_UNNEST_ONE && el.getElements().size() == 1) {
            Element e2 = (Element)el.getElements().get(0);
            this.visitAsGroup(e2);
            return;
        }
        this.out.print("{");
        this.out.incIndent(2);
        if (GROUP_FIRST_ON_SAME_LINE) {
            this.out.newline();
        }
        int row1 = this.out.getRow();
        this.out.pad();
        boolean first = true;
        ListIterator iter = el.getElements().listIterator();
        while (iter.hasNext()) {
            Element subElement = (Element)iter.next();
            if (!first) {
                if (GROUP_SEP_DOT) {
                    this.out.print(" . ");
                }
                this.out.newline();
            }
            subElement.visit(this);
            first = false;
        }
        this.out.decIndent(2);
        int row2 = this.out.getRow();
        if (row1 != row2) {
            this.out.newline();
        }
        this.out.print("}");
    }

    public void visit(ElementOptional el) {
        this.out.print("OPTIONAL");
        this.out.incIndent(2);
        this.out.newline();
        this.visitAsGroup(el.getOptionalElement());
        this.out.decIndent(2);
    }

    public void visit(ElementNamedGraph el) {
        String s = "GRAPH ";
        int len = s.length();
        this.out.print(s);
        s = el.getGraphNameNode() == null ? "*" : this.slotToString(this.context, el.getGraphNameNode());
        this.out.print(s);
        len += s.length();
        if (GRAPH_FIXED_INDENT) {
            this.out.incIndent(2);
            this.out.newline();
        } else {
            this.out.print(" ");
            this.out.incIndent(++len);
        }
        this.visitAsGroup(el.getElement());
        if (GRAPH_FIXED_INDENT) {
            this.out.decIndent(2);
        } else {
            this.out.decIndent(len);
        }
    }

    public void visit(ElementUnsaid el) {
        String s = "UNSAID ";
        int len = s.length();
        this.out.print(s);
        len += s.length();
        if (UNSAID_FIXED_INDENT) {
            this.out.incIndent(2);
            this.out.newline();
        } else {
            this.out.print(" ");
            this.out.incIndent(++len);
        }
        this.visitAsGroup(el.getElement());
        if (UNSAID_FIXED_INDENT) {
            this.out.decIndent(2);
        } else {
            this.out.decIndent(len);
        }
    }

    public void visit(ElementExtension el) {
        Expr expr;
        this.out.print("EXT ");
        String uri = el.getURI();
        String tmp = FmtUtils.stringForURI(uri, this.context.getPrefixMapping());
        this.out.print(tmp);
        this.out.print("(");
        int i = 1;
        while ((expr = el.getArg(i)) != null) {
            if (i != 1) {
                this.out.print(", ");
            }
            FmtExprARQ v = new FmtExprARQ(this.out, this.context);
            expr.visit(v);
            ++i;
        }
        this.out.print(")");
    }

    private void visitAsGroup(Element el) {
        boolean isGroup = el instanceof ElementGroup;
        if (!isGroup) {
            this.out.print("{ ");
            this.out.incIndent(2);
        }
        el.visit(this);
        if (!isGroup) {
            this.out.decIndent(2);
            this.out.print("}");
        }
    }

    protected void formatTriples(List triples) {
        if (!PRETTY_PRINT) {
            super.formatTriples(triples);
            return;
        }
        int x = 3;
        if (triples.size() == 0) {
            return;
        }
        this.setWidths(triples);
        if (this.subjectWidth > TRIPLES_SUBJECT_COLUMN) {
            this.subjectWidth = TRIPLES_SUBJECT_COLUMN;
        }
        if (this.predicateWidth > TRIPLES_PROPERTY_COLUMN) {
            this.predicateWidth = TRIPLES_PROPERTY_COLUMN;
        }
        ArrayList<Triple> subjAcc = new ArrayList<Triple>();
        Node subj = null;
        boolean first = true;
        int indent = -1;
        Iterator iter = triples.iterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (subj != null && t.getSubject().equals(subj)) {
                subjAcc.add(t);
                continue;
            }
            if (subj != null) {
                if (!first) {
                    this.out.println();
                }
                this.formatSameSubject(subj, subjAcc);
                first = false;
            }
            subj = t.getSubject();
            subjAcc.clear();
            subjAcc.add(t);
        }
        if (subj != null && subjAcc.size() != 0) {
            if (!first) {
                this.out.println();
            }
            first = false;
            this.formatSameSubject(subj, subjAcc);
        }
    }

    private void formatSameSubject(Node subject, List triples) {
        if (triples == null || triples.size() == 0) {
            return;
        }
        Iterator iter = triples.iterator();
        Triple t1 = (Triple)iter.next();
        int indent = this.subjectWidth + TRIPLES_COLUMN_GAP;
        int s1_len = this.printSubject(t1.getSubject());
        if (s1_len > TRIPLES_SUBJECT_LONG) {
            this.out.incIndent(indent);
            this.out.println();
        } else {
            this.printGap();
            this.out.incIndent(indent);
        }
        this.printProperty(t1.getPredicate());
        this.printGap();
        this.printObject(t1.getObject());
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            this.out.println(" ;");
            this.printProperty(t.getPredicate());
            this.printGap();
            this.printObject(t.getObject());
        }
        this.out.decIndent(indent);
        this.out.print(" .");
    }

    private void setWidths(List triples) {
        this.subjectWidth = -1;
        this.predicateWidth = -1;
        Iterator iter = triples.iterator();
        while (iter.hasNext()) {
            String p;
            Triple t = (Triple)iter.next();
            String s = this.slotToString(this.context, t.getSubject());
            if (s.length() > this.subjectWidth) {
                this.subjectWidth = s.length();
            }
            if ((p = this.slotToString(this.context, t.getPredicate())).length() <= this.predicateWidth) continue;
            this.predicateWidth = p.length();
        }
    }

    private void printGap() {
        this.out.print(' ', TRIPLES_COLUMN_GAP);
    }

    private int printSubject(Node s) {
        String str = this.slotToString(this.context, s);
        this.out.print(str);
        this.out.pad(this.subjectWidth);
        return str.length();
    }

    private int printProperty(Node p) {
        String str = this.slotToString(this.context, p);
        this.out.print(str);
        this.out.pad(this.predicateWidth);
        return str.length();
    }

    private int printObject(Node obj) {
        return this.printNoCol(obj);
    }

    private int printNoCol(Node node) {
        String str = this.slotToString(this.context, node);
        this.out.print(str);
        return str.length();
    }
}

