/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.serializer.FmtExpr;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.FmtUtils;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.PrefixMapping2;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QuerySerializer
implements QueryVisitor {
    static final int BLOCK_INDENT = 2;
    protected FormatterTemplate fmtTemplate;
    protected FormatterElement fmtElement;
    protected FmtExpr fmtExpr;
    protected IndentedWriter out = null;

    QuerySerializer(OutputStream _out, FormatterElement formatterElement, FmtExpr formatterExpr, FormatterTemplate formatterTemplate) {
        this(new IndentedWriter(_out), formatterElement, formatterExpr, formatterTemplate);
    }

    QuerySerializer(IndentedWriter iwriter, FormatterElement formatterElement, FmtExpr formatterExpr, FormatterTemplate formatterTemplate) {
        this.out = iwriter;
        this.fmtTemplate = formatterTemplate;
        this.fmtElement = formatterElement;
        this.fmtExpr = formatterExpr;
    }

    public void startVisit(Query query) {
    }

    public void visitResultForm(Query query) {
    }

    public void visitBase(Query query) {
        if (query.getBaseURI() != null && query.explicitlySetBaseURI()) {
            this.out.print("BASE    ");
            this.out.print("<" + query.getBaseURI() + ">");
            this.out.newline();
        }
    }

    public void visitPrefixes(Query query) {
        Map pmap = null;
        if (query.getPrefixMapping() instanceof PrefixMapping2) {
            PrefixMapping2 pm2 = (PrefixMapping2)query.getPrefixMapping();
            pmap = pm2.getNsPrefixMap(false);
        } else {
            pmap = query.getPrefixMapping().getNsPrefixMap();
        }
        if (pmap.size() > 0) {
            Iterator iter = pmap.keySet().iterator();
            while (iter.hasNext()) {
                String k = (String)iter.next();
                String v = (String)pmap.get(k);
                this.out.print("PREFIX  ");
                this.out.print(k);
                this.out.print(':');
                this.out.print(' ', -k.length());
                this.out.print(" <" + v + ">");
                this.out.newline();
            }
            this.out.newline();
        }
    }

    public void visitSelectResultForm(Query query) {
        this.out.print("SELECT ");
        if (query.isDistinct()) {
            this.out.print("DISTINCT ");
        }
        this.out.print(" ");
        if (query.isQueryResultStar()) {
            this.out.print("*");
        } else {
            QuerySerializer.appendVarList(query, this.out, query.getResultVars());
        }
        this.out.newline();
    }

    public void visitConstructResultForm(Query query) {
        this.out.print("CONSTRUCT ");
        if (query.isQueryResultStar()) {
            this.out.print("*");
            this.out.newline();
        } else {
            this.out.incIndent(2);
            this.out.newline();
            Template t = query.getConstructTemplate();
            t.visit(this.fmtTemplate);
            this.out.decIndent(2);
        }
    }

    public void visitDescribeResultForm(Query query) {
        this.out.print("DESCRIBE ");
        if (query.isQueryResultStar()) {
            this.out.print("*");
        } else {
            QuerySerializer.appendVarList(query, this.out, query.getResultVars());
            if (query.getResultVars().size() > 0 && query.getResultURIs().size() > 0) {
                this.out.print(" ");
            }
            QuerySerializer.appendURIList(query, this.out, query.getResultURIs());
        }
        this.out.newline();
    }

    public void visitAskResultForm(Query query) {
        this.out.print("ASK");
        this.out.newline();
    }

    public void visitDatasetDecl(Query query) {
        String uri;
        Iterator iter;
        if (query.getGraphURIs() != null && query.getGraphURIs().size() != 0) {
            iter = query.getGraphURIs().iterator();
            while (iter.hasNext()) {
                uri = (String)iter.next();
                this.out.print("FROM ");
                this.out.print(FmtUtils.stringForURI(uri, query.getPrefixMapping()));
                this.out.newline();
            }
        }
        if (query.getNamedGraphURIs() != null && query.getNamedGraphURIs().size() != 0) {
            iter = query.getNamedGraphURIs().iterator();
            while (iter.hasNext()) {
                uri = (String)iter.next();
                this.out.print("FROM NAMED ");
                this.out.print(FmtUtils.stringForURI(uri, query.getPrefixMapping()));
                this.out.newline();
            }
        }
    }

    public void visitQueryPattern(Query query) {
        if (query.getQueryPattern() != null) {
            this.out.print("WHERE");
            this.out.incIndent(2);
            this.out.newline();
            Element el = query.getQueryPattern();
            if (this.fmtElement.topMustBeGroup() && !(el instanceof ElementGroup)) {
                ElementGroup elg = new ElementGroup();
                elg.addElement(el);
                el = elg;
            }
            el.visit(this.fmtElement);
            this.out.decIndent(2);
            this.out.newline();
        }
    }

    public void visitOrderBy(Query query) {
        if (query.hasOrderBy()) {
            this.out.print("ORDER BY ");
            boolean first = true;
            Iterator iter = query.getOrderBy().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    this.out.print(" ");
                }
                SortCondition sc = (SortCondition)iter.next();
                sc.format(this.fmtExpr, this.out);
                first = false;
            }
            this.out.println();
        }
    }

    public void visitLimit(Query query) {
        if (query.hasLimit()) {
            this.out.print("LIMIT   " + query.getLimit());
            this.out.newline();
        }
    }

    public void visitOffset(Query query) {
        if (query.hasOffset()) {
            this.out.print("OFFSET  " + query.getOffset());
            this.out.newline();
        }
    }

    public void finishVisit(Query query) {
        this.out.flush();
    }

    static void appendVarList(Query query, IndentedWriter sb, List vars) {
        boolean first = true;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            if (!first) {
                sb.print(" ");
            }
            sb.print("?");
            sb.print(var);
            first = false;
        }
    }

    static void appendURIList(Query query, IndentedWriter sb, List vars) {
        SerializationContext cxt = new SerializationContext(query);
        boolean first = true;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!first) {
                sb.print(" ");
            }
            sb.print(FmtUtils.stringForNode(node, cxt));
            first = false;
        }
    }
}

