/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.query.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Loader {
    private static Log log = LogFactory.getLog((Class)Loader.class);

    public static Class loadClass(String classNameOrURI) {
        return Loader.loadClass(classNameOrURI, null);
    }

    public static Class loadClass(String classNameOrURI, Class requiredClass) {
        if (classNameOrURI.startsWith("http:")) {
            return null;
        }
        if (classNameOrURI.startsWith("urn:")) {
            return null;
        }
        String className = classNameOrURI;
        if (classNameOrURI.startsWith("java:")) {
            className = classNameOrURI.substring("java:".length());
        }
        Class<?> classObj = null;
        try {
            classObj = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            log.warn((Object)("Class not found: " + className));
            return null;
        }
        if (requiredClass != null && !requiredClass.isAssignableFrom(classObj)) {
            log.warn((Object)("Class '" + className + "' found but not a " + Utils.classShortName(requiredClass)));
            return null;
        }
        return classObj;
    }

    public static Object loadAndInstantiate(String uri, Class requiredClass) {
        Class classObj = Loader.loadClass(uri, requiredClass);
        if (classObj == null) {
            return null;
        }
        Object module = null;
        try {
            module = classObj.newInstance();
        }
        catch (Exception ex) {
            String className = uri.substring("java:".length());
            log.warn((Object)("Exception during instantiation '" + className + "': " + ex.getMessage()));
            return null;
        }
        return module;
    }
}

