/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.graph;

import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import simpack.api.IGraphNode;
import simpack.api.impl.AbstractGraphAccessor;
import simpack.exception.InvalidElementException;
import simpack.util.graph.GraphNode;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaOntologyAccessor
extends AbstractGraphAccessor {
    public static Logger logger = Logger.getLogger(JenaOntologyAccessor.class);
    private OntModel model;
    private Filter anonFilter;
    private Filter sameNamespaceFilter;
    private String ontologyRootURI;
    private TreeMap<String, Integer> classURIsToIDsMap;
    private TreeMap<Integer, String> idsToClassURIsMap;
    private SparseDoubleMatrix2D shortestDistanceToDescendantOrChildMatrix;
    private SparseDoubleMatrix2D longestDistanceToDescendantOrChildMatrix;

    public JenaOntologyAccessor(String string, String string2, String string3, String string4, OntModelSpec ontModelSpec) {
        this.setUpAccessor(string, string2, string3, string4, ontModelSpec);
        this.parseHierarchy();
    }

    @Override
    public int size() {
        int n = 0;
        ExtendedIterator extendedIterator = this.model.listClasses().filterDrop(this.anonFilter);
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
            ++n;
        }
        logger.debug((Object)("Size of set is " + n));
        return n;
    }

    @Override
    public double getShortestPath(IGraphNode iGraphNode, IGraphNode iGraphNode2) throws InvalidElementException {
        if (!this.contains(iGraphNode)) {
            throw new InvalidElementException("Node " + ((Object)iGraphNode).toString() + " is invalid");
        }
        if (!this.contains(iGraphNode2)) {
            throw new InvalidElementException("Node " + ((Object)iGraphNode2).toString() + " is invalid");
        }
        if (((Object)iGraphNode).toString().equals(((Object)iGraphNode2).toString())) {
            return 0.0;
        }
        IGraphNode iGraphNode3 = this.getMostRecentCommonAncestor(iGraphNode, iGraphNode2);
        int n = this.classURIsToIDsMap.get(((Object)iGraphNode3).toString());
        int n2 = this.classURIsToIDsMap.get(((Object)iGraphNode).toString());
        int n3 = this.classURIsToIDsMap.get(((Object)iGraphNode2).toString());
        return this.shortestDistanceToDescendantOrChildMatrix.getQuick(n, n2) + this.shortestDistanceToDescendantOrChildMatrix.getQuick(n, n3);
    }

    public double getMaxOntologyDepth() {
        int n = this.classURIsToIDsMap.get(this.ontologyRootURI);
        double d = -2.147483648E9;
        int n2 = 0;
        logger.debug((Object)this.longestDistanceToDescendantOrChildMatrix.viewRow(n));
        for (int i = 0; i < this.longestDistanceToDescendantOrChildMatrix.columns(); ++i) {
            double d2 = this.longestDistanceToDescendantOrChildMatrix.getQuick(n, i);
            if (!(d2 > d)) continue;
            d = d2;
            n2 = i;
        }
        logger.debug((Object)("Maximum depth in ontology is " + d + " from " + this.ontologyRootURI + " to " + this.idsToClassURIsMap.get(n2)));
        return d;
    }

    @Override
    public double getMaximumDirectedPathLength() {
        int n = this.classURIsToIDsMap.get(this.ontologyRootURI);
        logger.debug((Object)this.longestDistanceToDescendantOrChildMatrix.viewRow(n));
        double[] dArray = new double[this.longestDistanceToDescendantOrChildMatrix.rows()];
        for (int i = 0; i < this.longestDistanceToDescendantOrChildMatrix.columns(); ++i) {
            dArray[i] = this.longestDistanceToDescendantOrChildMatrix.getQuick(n, i);
        }
        Arrays.sort(dArray);
        if (dArray.length == 1) {
            double d = 0.0;
            return 0.0;
        }
        double d = dArray[dArray.length - 1] + dArray[dArray.length - 2];
        logger.debug((Object)("Maximum path length in ontology is " + d));
        return d;
    }

    @Override
    public IGraphNode getRoot() {
        return new GraphNode(this.ontologyRootURI);
    }

    @Override
    public IGraphNode getMostRecentCommonAncestor(IGraphNode iGraphNode, IGraphNode iGraphNode2) throws InvalidElementException {
        if (!this.contains(iGraphNode)) {
            throw new InvalidElementException("Node " + ((Object)iGraphNode).toString() + " is invalid");
        }
        if (!this.contains(iGraphNode2)) {
            throw new InvalidElementException("Node " + ((Object)iGraphNode2).toString() + " is invalid");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        String string = iGraphNode.getUserObject().toString();
        String string2 = iGraphNode2.getUserObject().toString();
        OntClass ontClass = this.model.getOntClass(string);
        OntClass ontClass2 = this.model.getOntClass(string2);
        ExtendedIterator extendedIterator = ontClass.listSuperClasses().filterDrop(this.anonFilter);
        extendedIterator = extendedIterator.filterDrop(this.sameNamespaceFilter);
        while (extendedIterator.hasNext()) {
            treeSet.add(((OntClass)extendedIterator.next()).getURI());
        }
        extendedIterator = ontClass2.listSuperClasses().filterDrop(this.anonFilter);
        extendedIterator = extendedIterator.filterDrop(this.sameNamespaceFilter);
        while (extendedIterator.hasNext()) {
            treeSet2.add(((OntClass)extendedIterator.next()).getURI());
        }
        if (treeSet.contains(string2)) {
            return new GraphNode(string2);
        }
        if (treeSet2.contains(string)) {
            return new GraphNode(string);
        }
        treeSet.retainAll(treeSet2);
        int n = this.classURIsToIDsMap.get(string);
        int n2 = this.classURIsToIDsMap.get(string2);
        int n3 = 0;
        double d = 2.147483647E9;
        for (String string3 : treeSet) {
            logger.debug((Object)string3);
            int n4 = this.classURIsToIDsMap.get(string3);
            double d2 = this.shortestDistanceToDescendantOrChildMatrix.getQuick(n4, n) + this.shortestDistanceToDescendantOrChildMatrix.getQuick(n4, n2);
            if (!(d2 < d)) continue;
            d = d2;
            n3 = n4;
        }
        if (logger.isDebugEnabled()) {
            OntClass ontClass3 = this.model.getOntClass(this.idsToClassURIsMap.get(n3));
            System.out.println("MRCA of " + ontClass.getModel().shortForm(ontClass.getURI()) + " and " + ontClass2.getModel().shortForm(ontClass2.getURI()) + " is " + ontClass3.getModel().shortForm(ontClass3.getURI()));
        }
        return new GraphNode(this.idsToClassURIsMap.get(n3));
    }

    @Override
    public Set<IGraphNode> getSuccessors(IGraphNode iGraphNode, boolean bl) throws InvalidElementException {
        OntResource ontResource = this.model.getOntResource(((Object)iGraphNode).toString());
        if (ontResource != null && ontResource.isClass()) {
            TreeSet<IGraphNode> treeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            OntClass ontClass = ontResource.asClass();
            ExtendedIterator extendedIterator = ontClass.listSubClasses(bl).filterDrop(this.anonFilter);
            while (extendedIterator.hasNext()) {
                treeSet.add(new GraphNode(((OntClass)extendedIterator.next()).getURI()));
            }
            return treeSet;
        }
        throw new InvalidElementException("Node " + ((Object)iGraphNode).toString() + " is invalid");
    }

    @Override
    public Set<IGraphNode> getPredecessors(IGraphNode iGraphNode, boolean bl) throws InvalidElementException {
        OntResource ontResource = this.model.getOntResource(((Object)iGraphNode).toString());
        if (ontResource != null && ontResource.isClass()) {
            TreeSet<IGraphNode> treeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
            OntClass ontClass = ontResource.asClass();
            ExtendedIterator extendedIterator = ontClass.listSuperClasses(bl).filterDrop(this.anonFilter);
            extendedIterator = extendedIterator.filterDrop(this.sameNamespaceFilter);
            while (extendedIterator.hasNext()) {
                OntClass ontClass2 = (OntClass)extendedIterator.next();
                treeSet.add(new GraphNode(ontClass2.getURI()));
            }
            return treeSet;
        }
        throw new InvalidElementException("Node " + ((Object)iGraphNode).toString() + " is invalid");
    }

    private void setUpAccessor(String string, String string2, String string3, final String string4, OntModelSpec ontModelSpec) {
        this.model = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        if (string2 != null) {
            this.model.getDocumentManager().addAltEntry(string, string2);
        }
        this.model.read(string, string3, null);
        this.ontologyRootURI = string4;
        this.anonFilter = new Filter(){

            public boolean accept(Object object) {
                return ((Resource)object).isAnon();
            }
        };
        this.sameNamespaceFilter = new Filter(){

            public boolean accept(Object object) {
                return !((Resource)object).getNameSpace().equals(JenaOntologyAccessor.this.model.getOntClass(string4).getNameSpace());
            }
        };
        this.calculateShortestAndLongestDistanceToDescendantOrChildMatrix();
    }

    /*
     * WARNING - void declaration
     */
    private void calculateShortestAndLongestDistanceToDescendantOrChildMatrix() {
        void var5_14;
        void var5_12;
        int n;
        Set<String> set;
        TreeSet<String> treeSet = new TreeSet<String>();
        ExtendedIterator extendedIterator = this.model.listClasses().filterDrop(this.anonFilter);
        while (extendedIterator.hasNext()) {
            treeSet.add(((OntClass)extendedIterator.next()).getURI());
        }
        this.classURIsToIDsMap = new TreeMap();
        int n2 = 0;
        for (String object2 : treeSet) {
            this.classURIsToIDsMap.put(object2, n2++);
        }
        if (logger.isDebugEnabled()) {
            set = this.classURIsToIDsMap.keySet();
            for (String string : set) {
                n = this.classURIsToIDsMap.get(string);
                System.out.println("[" + string + "," + n + "]");
            }
        }
        this.idsToClassURIsMap = new TreeMap();
        set = this.classURIsToIDsMap.keySet();
        for (String string : set) {
            n = this.classURIsToIDsMap.get(string);
            this.idsToClassURIsMap.put(n, string);
        }
        if (logger.isDebugEnabled()) {
            Set<Integer> set2 = this.idsToClassURIsMap.keySet();
            for (Integer n3 : set2) {
                String string = this.idsToClassURIsMap.get(n3);
                System.out.println("[" + n3 + "," + string + "]");
            }
        }
        this.shortestDistanceToDescendantOrChildMatrix = new SparseDoubleMatrix2D(treeSet.size(), treeSet.size());
        this.shortestDistanceToDescendantOrChildMatrix.viewPart(0, 0, this.shortestDistanceToDescendantOrChildMatrix.rows(), this.shortestDistanceToDescendantOrChildMatrix.columns()).assign(2.147483647E9);
        this.longestDistanceToDescendantOrChildMatrix = new SparseDoubleMatrix2D(treeSet.size(), treeSet.size());
        this.longestDistanceToDescendantOrChildMatrix.viewPart(0, 0, this.longestDistanceToDescendantOrChildMatrix.rows(), this.longestDistanceToDescendantOrChildMatrix.columns()).assign(-2.147483648E9);
        boolean bl = false;
        while (var5_12 < this.shortestDistanceToDescendantOrChildMatrix.rows()) {
            void var6_22;
            boolean bl2 = false;
            while (var6_22 < this.shortestDistanceToDescendantOrChildMatrix.columns()) {
                if (var5_12 == var6_22) {
                    this.shortestDistanceToDescendantOrChildMatrix.setQuick((int)var5_12, (int)var6_22, 0.0);
                    this.longestDistanceToDescendantOrChildMatrix.setQuick((int)var5_12, (int)var6_22, 0.0);
                }
                ++var6_22;
            }
            ++var5_12;
        }
        Vector vector = new Vector();
        set = this.classURIsToIDsMap.keySet();
        for (String string : set) {
            int n4 = this.classURIsToIDsMap.get(string);
            OntClass ontClass = this.model.getOntClass(string);
            ExtendedIterator extendedIterator2 = ontClass.listSubClasses(true);
            while (extendedIterator2.hasNext()) {
                OntClass ontClass2 = (OntClass)extendedIterator2.next();
                if (logger.isDebugEnabled()) {
                    System.out.println("Class " + ontClass.getModel().shortForm(ontClass.getURI()) + " has child " + ontClass2.getModel().shortForm(ontClass2.getURI()));
                }
                int n5 = this.classURIsToIDsMap.get(ontClass2.getURI());
                this.shortestDistanceToDescendantOrChildMatrix.setQuick(n4, n5, 1.0);
                this.longestDistanceToDescendantOrChildMatrix.setQuick(n4, n5, 1.0);
                Vector<Integer> vector2 = new Vector<Integer>();
                vector2.add(n4);
                vector2.add(n5);
                vector.add(vector2);
            }
        }
        while (!var5_14.isEmpty()) {
            Vector vector3 = new Vector();
            for (Vector vector4 : var5_14) {
                int n6 = (Integer)vector4.get(0);
                int n7 = (Integer)vector4.get(1);
                double d = this.shortestDistanceToDescendantOrChildMatrix.getQuick(n6, n7);
                double d2 = this.longestDistanceToDescendantOrChildMatrix.getQuick(n6, n7);
                String string = this.idsToClassURIsMap.get(n7);
                OntClass ontClass = this.model.getOntClass(string);
                ExtendedIterator extendedIterator3 = ontClass.listSubClasses(true);
                while (extendedIterator3.hasNext()) {
                    OntClass ontClass3 = (OntClass)extendedIterator3.next();
                    int n8 = this.classURIsToIDsMap.get(ontClass3.getURI());
                    double d3 = this.shortestDistanceToDescendantOrChildMatrix.getQuick(n6, n8);
                    double d4 = this.longestDistanceToDescendantOrChildMatrix.getQuick(n6, n8);
                    if (d + 1.0 < d3) {
                        this.shortestDistanceToDescendantOrChildMatrix.setQuick(n6, n8, d + 1.0);
                    }
                    if (d2 + 1.0 > d4) {
                        this.longestDistanceToDescendantOrChildMatrix.setQuick(n6, n8, d2 + 1.0);
                    }
                    Vector<Integer> vector5 = new Vector<Integer>();
                    vector5.add(n6);
                    vector5.add(n8);
                    vector3.add(vector5);
                }
            }
            Vector vector6 = vector3;
        }
    }

    private void parseClassDescription(OntClass ontClass, String string) {
        if (!ontClass.isRestriction() && !ontClass.isAnon()) {
            if (string != null) {
                this.setEdge(new GraphNode(string), new GraphNode(ontClass.getURI()));
            } else {
                this.addNode(new GraphNode(ontClass.getURI()));
            }
        }
    }

    private void parseClass(OntClass ontClass, List<OntClass> list, String string) {
        this.parseClassDescription(ontClass, string);
        if (ontClass.canAs(OntClass.class) && !list.contains(ontClass)) {
            ExtendedIterator extendedIterator = ontClass.listSubClasses(true);
            while (extendedIterator.hasNext()) {
                OntClass ontClass2 = (OntClass)extendedIterator.next();
                String string2 = ontClass.getURI();
                list.add(ontClass);
                this.parseClass(ontClass2, list, string2);
                list.remove(ontClass);
            }
        }
    }

    private void parseHierarchy() {
        ExtendedIterator extendedIterator = this.model.listHierarchyRootClasses().filterDrop(this.anonFilter);
        while (extendedIterator.hasNext()) {
            OntClass ontClass = (OntClass)extendedIterator.next();
            this.parseClass(ontClass, new ArrayList<OntClass>(), null);
        }
    }
}

