/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.list;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.PriorityQueue;
import simpack.api.impl.CollectionAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.weightingscheme.AbstractTFIDF;
import simpack.util.Vector;
import simpack.util.corpus.Indexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexAccessor<E>
extends CollectionAccessor<E> {
    public static Logger logger = Logger.getLogger(LuceneIndexAccessor.class);
    public static Analyzer analyzer = Indexer.DEFAULT_ANALYZER;
    private String[] fieldNames = Indexer.DEFAULT_FIELD_NAMES;
    private String index;
    private IndexReader ir;
    private IndexSearcher is;

    public LuceneIndexAccessor(String string) throws IOException {
        this.index = string;
        this.createReader();
        this.createSearcher();
    }

    public IndexReader getIndexReader() {
        return this.ir;
    }

    public IndexSearcher getIndexSearcher() {
        return this.is;
    }

    @Override
    public int getSize() {
        return this.ir.numDocs();
    }

    @Override
    public boolean containsElement(E e) {
        try {
            QueryParser queryParser = new QueryParser("title", analyzer);
            Hits hits = this.is.search(queryParser.parse((String)e));
            int n = hits.length();
            return n > 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return false;
        }
    }

    @Override
    public Vector<Double> getWeights(E e) throws InvalidElementException {
        try {
            Vector<Double> vector = new Vector<Double>();
            int n = this.getDocID((String)e);
            if (n == -1) {
                throw new InvalidElementException("Document '" + (String)e + "' not in index.");
            }
            double d = this.getMaxTF(this.getTermFrequencies(n));
            TermEnum termEnum = this.ir.terms();
            while (termEnum.next()) {
                Term term = termEnum.term();
                double d2 = 0.0;
                if (!term.field().equals("contents")) continue;
                double d3 = AbstractTFIDF.idf2(this.ir.numDocs(), termEnum.docFreq());
                TermDocs termDocs = this.ir.termDocs(term);
                if (termDocs.skipTo(n)) {
                    d2 = AbstractTFIDF.tfSaltonBuckley(termDocs.freq(), d);
                    vector.add(d2 * d3);
                    continue;
                }
                vector.add(0.0);
            }
            return vector;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public PriorityQueue retrieveTerms(int n) throws IOException {
        Map<String, Int> map = this.getTermFrequencies(n);
        return this.createQueue(map);
    }

    private Map<String, Int> getTermFrequencies(int n) throws IOException {
        HashMap<String, Int> hashMap = new HashMap<String, Int>();
        String string = "contents";
        TermFreqVector termFreqVector = this.ir.getTermFreqVector(n, string);
        if (termFreqVector == null) {
            Document document = this.ir.document(n);
            String[] stringArray = document.getValues(string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addTermFrequencies(new StringReader(stringArray[i]), hashMap, string);
                }
            }
        } else {
            this.addTermFrequencies(hashMap, termFreqVector);
        }
        return hashMap;
    }

    private void createReader() throws IOException {
        FSDirectory fSDirectory = FSDirectory.getDirectory((String)this.index, (boolean)false);
        this.ir = IndexReader.open((Directory)fSDirectory);
    }

    private void createSearcher() throws IOException {
        FSDirectory fSDirectory = FSDirectory.getDirectory((String)this.index, (boolean)false);
        this.is = new IndexSearcher((Directory)fSDirectory);
    }

    private int getDocID(String string) throws Exception {
        QueryParser queryParser = new QueryParser("title", analyzer);
        Hits hits = this.is.search(queryParser.parse(string));
        if (hits.length() == 1) {
            return hits.id(0);
        }
        return -1;
    }

    private double getMaxTF(Map map) {
        double d = 0.0;
        for (String string : map.keySet()) {
            int n = ((Int)map.get((Object)string)).x;
            if (!((double)n > d)) continue;
            d = n;
        }
        return d;
    }

    private double getNormalization(Map map) throws IOException {
        int n = this.ir.numDocs();
        double d = 0.0;
        for (String string : map.keySet()) {
            int n2 = ((Int)map.get((Object)string)).x;
            int n3 = 0;
            int n4 = this.ir.docFreq(new Term("contents", string));
            int n5 = n3 = n4 > n3 ? n4 : n3;
            if (n3 == 0) continue;
            double d2 = AbstractTFIDF.idf2(n3, n);
            d += (double)(n2 * n2) * (d2 * d2);
        }
        return Math.sqrt(d);
    }

    private PriorityQueue createQueue(Map map) throws IOException {
        int n = this.ir.numDocs();
        FreqQ freqQ = new FreqQ(map.size());
        double d = this.getMaxTF(map);
        for (String string : map.keySet()) {
            double d2 = ((Int)map.get((Object)string)).x;
            d2 = AbstractTFIDF.tfSaltonBuckley(d2, d);
            String string2 = this.fieldNames[0];
            int n2 = 0;
            int n3 = this.ir.docFreq(new Term("contents", string));
            string2 = "contents";
            int n4 = n2 = n3 > n2 ? n3 : n2;
            if (n2 == 0) continue;
            double d3 = AbstractTFIDF.idf2(n, n2);
            double d4 = d2 * d3;
            freqQ.insert(new Object[]{string, string2, new Double(d4), new Double(d3), new Integer(n2), new Double(d2), new Double(0.0)});
        }
        return freqQ;
    }

    private void addTermFrequencies(Reader reader, Map<String, Int> map, String string) throws IOException {
        Token token;
        TokenStream tokenStream = Indexer.DEFAULT_ANALYZER.tokenStream(string, reader);
        while ((token = tokenStream.next()) != null) {
            String string2 = token.termText();
            Int intVal = map.get(string2);
            if (intVal == null) {
                map.put(string2, new Int());
                continue;
            }
            ++intVal.x;
        }
    }

    private void addTermFrequencies(Map<String, Int> map, TermFreqVector termFreqVector) {
        String[] stringArray = termFreqVector.getTerms();
        int[] nArray = termFreqVector.getTermFrequencies();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Int intVal = map.get(string);
            if (intVal == null) {
                intVal = new Int();
                intVal.x = nArray[i];
                map.put(string, intVal);
                continue;
            }
            intVal.x += nArray[i];
        }
    }

    private static class FreqQ
    extends PriorityQueue {
        FreqQ(int n) {
            this.initialize(n);
        }

        protected boolean lessThan(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            Double d = (Double)objectArray[2];
            Double d2 = (Double)objectArray2[2];
            return d > d2;
        }
    }

    private static class Int {
        int x = 1;

        Int() {
        }
    }
}

