/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.string;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import simpack.api.ISequenceAccessor;
import simpack.api.IToken;
import simpack.api.ITokenizer;
import simpack.api.impl.CollectionAccessor;
import simpack.tokenizer.DummyTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAccessor
extends CollectionAccessor<String>
implements ISequenceAccessor<String> {
    private String s;

    public StringAccessor(String string) {
        this(string, new DummyTokenizer());
    }

    public StringAccessor(String string, ITokenizer iTokenizer) {
        this.s = string;
        this.elements = new Vector();
        List<IToken> list = iTokenizer.tokenize(string);
        for (IToken iToken : list) {
            this.elements.add(iToken.getValue());
        }
    }

    public int length() {
        return this.getSize();
    }

    public String unwrap() {
        return this.s;
    }

    public char charAt(int n) {
        return this.s.charAt(n);
    }

    public String getTokenAt(int n) {
        return this.elements.toArray(new String[0])[n];
    }

    @Override
    public int getElementFrequency(String string) {
        int n = 0;
        String[] stringArray = this.elements.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int[] getElementFrequencies() {
        String[] stringArray = this.elements.toArray(new String[0]);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.getElementFrequency(stringArray[i]);
        }
        return nArray;
    }

    @Override
    public List<String> getSequence() {
        return new ArrayList<String>(this.elements);
    }

    @Override
    public String toString() {
        return this.unwrap();
    }
}

