/*
 * Decompiled with CFR 0.152.
 */
package simpack.api.impl;

import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphAccessor
implements IGraphAccessor {
    private static Logger logger = Logger.getLogger(AbstractGraphAccessor.class);
    protected TreeSet<IGraphNode> nodeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected IGraphNode root;

    @Override
    public int size() {
        return this.nodeSet.size();
    }

    @Override
    public TreeSet<IGraphNode> getNodeSet() {
        return this.nodeSet;
    }

    @Override
    public IGraphNode getNode(String string) {
        for (IGraphNode iGraphNode : this.nodeSet) {
            if (!iGraphNode.getLabel().equals(string)) continue;
            return iGraphNode;
        }
        return null;
    }

    @Override
    public void addNode(IGraphNode iGraphNode) {
        this.nodeSet.add(iGraphNode);
    }

    @Override
    public boolean contains(IGraphNode iGraphNode) {
        for (IGraphNode iGraphNode2 : this.nodeSet) {
            if (!iGraphNode2.equals(iGraphNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IGraphNode getRoot() {
        if (this.root == null) {
            for (IGraphNode iGraphNode : this.nodeSet) {
                if (iGraphNode.getPredecessorSet().size() != 0) continue;
                this.root = iGraphNode;
            }
        }
        return this.root;
    }

    @Override
    public void setEdge(IGraphNode iGraphNode, IGraphNode iGraphNode2) {
        IGraphNode iGraphNode3 = null;
        logger.debug((Object)("Want to set an edge for " + iGraphNode.getLabel() + " -> " + iGraphNode2.getLabel()));
        if (this.contains(iGraphNode)) {
            iGraphNode3 = this.getNode(iGraphNode.getLabel());
            logger.debug((Object)("Node contained " + ((Object)iGraphNode3).toString()));
        } else {
            iGraphNode3 = iGraphNode;
            logger.debug((Object)("Adding node " + ((Object)iGraphNode3).toString()));
            this.addNode(iGraphNode3);
        }
        IGraphNode iGraphNode4 = null;
        if (this.contains(iGraphNode2)) {
            iGraphNode4 = this.getNode(iGraphNode2.getLabel());
            logger.debug((Object)("Node contained " + ((Object)iGraphNode4).toString()));
        } else {
            iGraphNode4 = iGraphNode2;
            logger.debug((Object)("Adding node " + ((Object)iGraphNode4).toString()));
            this.addNode(iGraphNode4);
        }
        logger.debug((Object)("Adding " + ((Object)iGraphNode3).toString() + " -> " + ((Object)iGraphNode4).toString()));
        iGraphNode3.addSuccessor(iGraphNode4);
        iGraphNode4.addPredecessor(iGraphNode3);
    }
}

